package io.github.vigoo.zioaws.savingsplans.model
import io.github.vigoo.zioaws.savingsplans.model.primitives.JsonSafeFilterValueString
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlanOfferingProperty(
    name: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingPropertyKey
    ] = None,
    value: Option[JsonSafeFilterValueString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingProperty = {
    import SavingsPlanOfferingProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingProperty
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingProperty.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingProperty
      .wrap(buildAwsValue())
}
object SavingsPlanOfferingProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingProperty =
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingProperty(
        nameValue.map(value => value),
        valueValue.map(value => value)
      )
    def nameValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingPropertyKey
    ]
    def valueValue: Option[JsonSafeFilterValueString]
    def name: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingPropertyKey
    ] = AwsError.unwrapOptionField("name", nameValue)
    def value: ZIO[Any, AwsError, JsonSafeFilterValueString] =
      AwsError.unwrapOptionField("value", valueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingProperty
  ) extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingProperty.ReadOnly {
    override def nameValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingPropertyKey
    ] = scala
      .Option(impl.name())
      .map(value =>
        io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingPropertyKey
          .wrap(value)
      )
    override def valueValue: Option[JsonSafeFilterValueString] =
      scala.Option(impl.value()).map(value => value: JsonSafeFilterValueString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingProperty
  ): io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingProperty.ReadOnly =
    new Wrapper(impl)
}
