package io.github.vigoo.zioaws.savingsplans.model
import java.lang.Integer
import io.github.vigoo.zioaws.savingsplans.model.primitives.{
  MaxResults,
  PaginationToken,
  SavingsPlanId,
  SavingsPlanArn
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSavingsPlansRequest(
    savingsPlanArns: Option[Iterable[SavingsPlanArn]] = None,
    savingsPlanIds: Option[Iterable[SavingsPlanId]] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[MaxResults] = None,
    states: Option[
      Iterable[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanState]
    ] = None,
    filters: Option[
      Iterable[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanFilter]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest = {
    import DescribeSavingsPlansRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest
      .builder()
      .optionallyWith(
        savingsPlanArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.savingsPlanArns)
      .optionallyWith(
        savingsPlanIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.savingsPlanIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(
        states.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statesWithStrings)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansRequest.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansRequest
      .wrap(buildAwsValue())
}
object DescribeSavingsPlansRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansRequest =
      io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansRequest(
        savingsPlanArnsValue.map(value => value),
        savingsPlanIdsValue.map(value => value),
        nextTokenValue.map(value => value),
        maxResultsValue.map(value => value),
        statesValue.map(value => value),
        filtersValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def savingsPlanArnsValue: Option[List[SavingsPlanArn]]
    def savingsPlanIdsValue: Option[List[SavingsPlanId]]
    def nextTokenValue: Option[PaginationToken]
    def maxResultsValue: Option[MaxResults]
    def statesValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanState]
    ]
    def filtersValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanFilter.ReadOnly]
    ]
    def savingsPlanArns: ZIO[Any, AwsError, List[SavingsPlanArn]] =
      AwsError.unwrapOptionField("savingsPlanArns", savingsPlanArnsValue)
    def savingsPlanIds: ZIO[Any, AwsError, List[SavingsPlanId]] =
      AwsError.unwrapOptionField("savingsPlanIds", savingsPlanIdsValue)
    def nextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def states: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanState
    ]] = AwsError.unwrapOptionField("states", statesValue)
    def filters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filtersValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest
  ) extends io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansRequest.ReadOnly {
    override def savingsPlanArnsValue: Option[List[SavingsPlanArn]] = scala
      .Option(impl.savingsPlanArns())
      .map(value =>
        value.asScala.map { item =>
          item: SavingsPlanArn
        }.toList
      )
    override def savingsPlanIdsValue: Option[List[SavingsPlanId]] = scala
      .Option(impl.savingsPlanIds())
      .map(value =>
        value.asScala.map { item =>
          item: SavingsPlanId
        }.toList
      )
    override def nextTokenValue: Option[PaginationToken] =
      scala.Option(impl.nextToken()).map(value => value: PaginationToken)
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
    override def statesValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanState]
    ] = scala
      .Option(impl.states())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanState.wrap(item)
        }.toList
      )
    override def filtersValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanFilter.ReadOnly]
    ] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanFilter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest
  ): io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansRequest.ReadOnly =
    new Wrapper(impl)
}
