package io.github.vigoo.zioaws.savingsplans.model
import io.github.vigoo.zioaws.savingsplans.model.primitives.PaginationToken
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSavingsPlansOfferingRatesResponse(
    searchResults: Option[Iterable[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRate
    ]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse = {
    import DescribeSavingsPlansOfferingRatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse
      .builder()
      .optionallyWith(
        searchResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.searchResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse
      .wrap(buildAwsValue())
}
object DescribeSavingsPlansOfferingRatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse =
      io.github.vigoo.zioaws.savingsplans.model
        .DescribeSavingsPlansOfferingRatesResponse(
          searchResultsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value)
        )
    def searchResultsValue: Option[List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRate.ReadOnly
    ]]
    def nextTokenValue: Option[PaginationToken]
    def searchResults: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRate.ReadOnly
    ]] = AwsError.unwrapOptionField("searchResults", searchResultsValue)
    def nextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse
  ) extends io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly {
    override def searchResultsValue: Option[List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRate.ReadOnly
    ]] = scala
      .Option(impl.searchResults())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRate
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[PaginationToken] =
      scala.Option(impl.nextToken()).map(value => value: PaginationToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse
  ): io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly =
    new Wrapper(impl)
}
