package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.savingsplans.model.DeleteQueuedSavingsPlanResponse.ReadOnly
import software.amazon.awssdk.services.savingsplans.{
  SavingsplansAsyncClientBuilder,
  SavingsplansAsyncClient
}
import io.github.vigoo.zioaws.savingsplans.Savingsplans
import io.github.vigoo.zioaws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.savingsplans.model.{
  DescribeSavingsPlansOfferingsResponse,
  DescribeSavingsPlansOfferingsRequest,
  DescribeSavingsPlansOfferingRatesResponse,
  ListTagsForResourceRequest,
  CreateSavingsPlanResponse,
  DescribeSavingsPlanRatesRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  CreateSavingsPlanRequest,
  DescribeSavingsPlanRatesResponse,
  DeleteQueuedSavingsPlanRequest,
  UntagResourceRequest,
  DescribeSavingsPlansOfferingRatesRequest,
  DescribeSavingsPlansResponse,
  TagResourceResponse,
  DeleteQueuedSavingsPlanResponse,
  TagResourceRequest,
  DescribeSavingsPlansRequest
}
import io.github.vigoo.zioaws.core.config.AwsConfig
import zio.{ZManaged, IO, ZIO, ZLayer, URLayer, Has}
import io.github.vigoo.zioaws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.test.mock.{Proxy, Mock}
package object savingsplans {
  import scala.jdk.CollectionConverters.*
  type Savingsplans = Has[Savingsplans.Service]
  object Savingsplans {
    trait Service extends AspectSupport[Service] {
      val api: SavingsplansAsyncClient
      def deleteQueuedSavingsPlan(
          request: io.github.vigoo.zioaws.savingsplans.model.DeleteQueuedSavingsPlanRequest
      ): IO[AwsError, ReadOnly]
      def describeSavingsPlansOfferings(
          request: io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsResponse.ReadOnly
      ]
      def describeSavingsPlans(
          request: io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansResponse.ReadOnly
      ]
      def createSavingsPlan(
          request: io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanResponse.ReadOnly
      ]
      def untagResource(
          request: io.github.vigoo.zioaws.savingsplans.model.UntagResourceRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.savingsplans.model.UntagResourceResponse.ReadOnly
      ]
      def describeSavingsPlansOfferingRates(
          request: io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly
      ]
      def listTagsForResource(
          request: io.github.vigoo.zioaws.savingsplans.model.ListTagsForResourceRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.savingsplans.model.ListTagsForResourceResponse.ReadOnly
      ]
      def describeSavingsPlanRates(
          request: io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesResponse.ReadOnly
      ]
      def tagResource(
          request: io.github.vigoo.zioaws.savingsplans.model.TagResourceRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.savingsplans.model.TagResourceResponse.ReadOnly
      ]
    }
    object SavingsplansMock extends Mock[Savingsplans] {
      object DeleteQueuedSavingsPlan
          extends Effect[
            io.github.vigoo.zioaws.savingsplans.model.DeleteQueuedSavingsPlanRequest,
            AwsError,
            ReadOnly
          ]
      object DescribeSavingsPlansOfferings
          extends Effect[
            io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsRequest,
            AwsError,
            io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsResponse.ReadOnly
          ]
      object DescribeSavingsPlans
          extends Effect[
            io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansRequest,
            AwsError,
            io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansResponse.ReadOnly
          ]
      object CreateSavingsPlan
          extends Effect[
            io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanRequest,
            AwsError,
            io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanResponse.ReadOnly
          ]
      object UntagResource
          extends Effect[
            io.github.vigoo.zioaws.savingsplans.model.UntagResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.savingsplans.model.UntagResourceResponse.ReadOnly
          ]
      object DescribeSavingsPlansOfferingRates
          extends Effect[
            io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest,
            AwsError,
            io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly
          ]
      object ListTagsForResource
          extends Effect[
            io.github.vigoo.zioaws.savingsplans.model.ListTagsForResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.savingsplans.model.ListTagsForResourceResponse.ReadOnly
          ]
      object DescribeSavingsPlanRates
          extends Effect[
            io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesRequest,
            AwsError,
            io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesResponse.ReadOnly
          ]
      object TagResource
          extends Effect[
            io.github.vigoo.zioaws.savingsplans.model.TagResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.savingsplans.model.TagResourceResponse.ReadOnly
          ]
      val compose: URLayer[Has[Proxy], Savingsplans] = ZLayer.fromServiceM {
        proxy =>
          withRuntime.map { rts =>
            new Savingsplans.Service {
              val api: SavingsplansAsyncClient = null
              def withAspect[R1](
                  newAspect: AwsCallAspect[R1],
                  r: R1
              ): Savingsplans.Service = this
              def deleteQueuedSavingsPlan(
                  request: io.github.vigoo.zioaws.savingsplans.model.DeleteQueuedSavingsPlanRequest
              ): IO[AwsError, ReadOnly] =
                proxy(DeleteQueuedSavingsPlan, request)
              def describeSavingsPlansOfferings(
                  request: io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsResponse.ReadOnly
              ] = proxy(DescribeSavingsPlansOfferings, request)
              def describeSavingsPlans(
                  request: io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansResponse.ReadOnly
              ] = proxy(DescribeSavingsPlans, request)
              def createSavingsPlan(
                  request: io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanResponse.ReadOnly
              ] = proxy(CreateSavingsPlan, request)
              def untagResource(
                  request: io.github.vigoo.zioaws.savingsplans.model.UntagResourceRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.savingsplans.model.UntagResourceResponse.ReadOnly
              ] = proxy(UntagResource, request)
              def describeSavingsPlansOfferingRates(
                  request: io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly
              ] = proxy(DescribeSavingsPlansOfferingRates, request)
              def listTagsForResource(
                  request: io.github.vigoo.zioaws.savingsplans.model.ListTagsForResourceRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.savingsplans.model.ListTagsForResourceResponse.ReadOnly
              ] = proxy(ListTagsForResource, request)
              def describeSavingsPlanRates(
                  request: io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesResponse.ReadOnly
              ] = proxy(DescribeSavingsPlanRates, request)
              def tagResource(
                  request: io.github.vigoo.zioaws.savingsplans.model.TagResourceRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.savingsplans.model.TagResourceResponse.ReadOnly
              ] = proxy(TagResource, request)
            }
          }
      }
    }
  }
  val live: ZLayer[AwsConfig, java.lang.Throwable, Savingsplans] = customized(
    identity
  )
  def customized(
      customization: SavingsplansAsyncClientBuilder => SavingsplansAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Savingsplans] = managed(
    customization
  ).toLayer
  def managed(
      customization: SavingsplansAsyncClientBuilder => SavingsplansAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Savingsplans.Service] = for (
    awsConfig <- ZManaged.service[AwsConfig.Service];
    executor <- ZIO.executor.toManaged_;
    builder = SavingsplansAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[SavingsplansAsyncClient, SavingsplansAsyncClientBuilder](
        builder
      )
      .toManaged_;
    b1 <- awsConfig
      .configureHttpClient[
        SavingsplansAsyncClient,
        SavingsplansAsyncClientBuilder
      ](
        b0,
        io.github.vigoo.zioaws.core.httpclient
          .ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged_; client <- zio.ZIO(customization(b1).build()).toManaged_
  )
    yield new SavingsplansImpl(
      client,
      AwsCallAspect.identity,
      ().asInstanceOf[Any]
    )
  private class SavingsplansImpl[R](
      override val api: SavingsplansAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: R
  ) extends Savingsplans.Service
      with AwsServiceBase[R, SavingsplansImpl] {
    override val serviceName: String = "Savingsplans"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: R1
    ): SavingsplansImpl[R1] = new SavingsplansImpl(api, newAspect, r)
    def deleteQueuedSavingsPlan(
        request: io.github.vigoo.zioaws.savingsplans.model.DeleteQueuedSavingsPlanRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      DeleteQueuedSavingsPlanRequest,
      DeleteQueuedSavingsPlanResponse
    ]("deleteQueuedSavingsPlan", api.deleteQueuedSavingsPlan)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.savingsplans.model.DeleteQueuedSavingsPlanResponse.wrap
    ).provide(r)
    def describeSavingsPlansOfferings(
        request: io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSavingsPlansOfferingsRequest,
      DescribeSavingsPlansOfferingsResponse
    ]("describeSavingsPlansOfferings", api.describeSavingsPlansOfferings)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsResponse.wrap
    ).provide(r)
    def describeSavingsPlans(
        request: io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSavingsPlansRequest,
      DescribeSavingsPlansResponse
    ]("describeSavingsPlans", api.describeSavingsPlans)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansResponse.wrap
      )
      .provide(r)
    def createSavingsPlan(
        request: io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateSavingsPlanRequest,
      CreateSavingsPlanResponse
    ]("createSavingsPlan", api.createSavingsPlan)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanResponse.wrap
      )
      .provide(r)
    def untagResource(
        request: io.github.vigoo.zioaws.savingsplans.model.UntagResourceRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
      "untagResource",
      api.untagResource
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.savingsplans.model.UntagResourceResponse.wrap)
      .provide(r)
    def describeSavingsPlansOfferingRates(
        request: io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSavingsPlansOfferingRatesRequest,
      DescribeSavingsPlansOfferingRatesResponse
    ](
      "describeSavingsPlansOfferingRates",
      api.describeSavingsPlansOfferingRates
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse.wrap
      )
      .provide(r)
    def listTagsForResource(
        request: io.github.vigoo.zioaws.savingsplans.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.savingsplans.model.ListTagsForResourceResponse.wrap
      )
      .provide(r)
    def describeSavingsPlanRates(
        request: io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSavingsPlanRatesRequest,
      DescribeSavingsPlanRatesResponse
    ]("describeSavingsPlanRates", api.describeSavingsPlanRates)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesResponse.wrap
    ).provide(r)
    def tagResource(
        request: io.github.vigoo.zioaws.savingsplans.model.TagResourceRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[TagResourceRequest, TagResourceResponse](
      "tagResource",
      api.tagResource
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.savingsplans.model.TagResourceResponse.wrap)
      .provide(r)
  }
  def deleteQueuedSavingsPlan(
      request: io.github.vigoo.zioaws.savingsplans.model.DeleteQueuedSavingsPlanRequest
  ): ZIO[Savingsplans, AwsError, ReadOnly] =
    ZIO.accessM(_.get.deleteQueuedSavingsPlan(request))
  def describeSavingsPlansOfferings(
      request: io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsRequest
  ): ZIO[
    Savingsplans,
    AwsError,
    io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsResponse.ReadOnly
  ] = ZIO.accessM(_.get.describeSavingsPlansOfferings(request))
  def describeSavingsPlans(
      request: io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansRequest
  ): ZIO[
    Savingsplans,
    AwsError,
    io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansResponse.ReadOnly
  ] = ZIO.accessM(_.get.describeSavingsPlans(request))
  def createSavingsPlan(
      request: io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanRequest
  ): ZIO[
    Savingsplans,
    AwsError,
    io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanResponse.ReadOnly
  ] = ZIO.accessM(_.get.createSavingsPlan(request))
  def untagResource(
      request: io.github.vigoo.zioaws.savingsplans.model.UntagResourceRequest
  ): ZIO[
    Savingsplans,
    AwsError,
    io.github.vigoo.zioaws.savingsplans.model.UntagResourceResponse.ReadOnly
  ] = ZIO.accessM(_.get.untagResource(request))
  def describeSavingsPlansOfferingRates(
      request: io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest
  ): ZIO[
    Savingsplans,
    AwsError,
    io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly
  ] = ZIO.accessM(_.get.describeSavingsPlansOfferingRates(request))
  def listTagsForResource(
      request: io.github.vigoo.zioaws.savingsplans.model.ListTagsForResourceRequest
  ): ZIO[
    Savingsplans,
    AwsError,
    io.github.vigoo.zioaws.savingsplans.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.accessM(_.get.listTagsForResource(request))
  def describeSavingsPlanRates(
      request: io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesRequest
  ): ZIO[
    Savingsplans,
    AwsError,
    io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesResponse.ReadOnly
  ] = ZIO.accessM(_.get.describeSavingsPlanRates(request))
  def tagResource(
      request: io.github.vigoo.zioaws.savingsplans.model.TagResourceRequest
  ): ZIO[
    Savingsplans,
    AwsError,
    io.github.vigoo.zioaws.savingsplans.model.TagResourceResponse.ReadOnly
  ] = ZIO.accessM(_.get.tagResource(request))
}
