package io.github.vigoo.zioaws.savingsplans.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlanRateFilter(
    name: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilterName
    ] = None,
    values: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateFilter = {
    import SavingsPlanRateFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateFilter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilter.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilter
      .wrap(buildAwsValue())
}
object SavingsPlanRateFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilter =
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilter(
        nameValue.map(value => value),
        valuesValue.map(value => value)
      )
    def nameValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilterName
    ]
    def valuesValue: Option[List[String]]
    def name: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilterName
    ] = AwsError.unwrapOptionField("name", nameValue)
    def values: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("values", valuesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateFilter
  ) extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilter.ReadOnly {
    override def nameValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilterName
    ] = scala
      .Option(impl.name())
      .map(value =>
        io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilterName
          .wrap(value)
      )
    override def valuesValue: Option[List[String]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateFilter
  ): io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilter.ReadOnly =
    new Wrapper(impl)
}
