package io.github.vigoo.zioaws.savingsplans.model
import io.github.vigoo.zioaws.savingsplans.model.primitives.{
  SavingsPlanDescription,
  SavingsPlansDuration,
  UUID
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ParentSavingsPlanOffering(
    offeringId: Option[UUID] = None,
    paymentOption: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
    ] = None,
    planType: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType
    ] = None,
    durationSeconds: Option[SavingsPlansDuration] = None,
    currency: Option[io.github.vigoo.zioaws.savingsplans.model.CurrencyCode] =
      None,
    planDescription: Option[SavingsPlanDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.ParentSavingsPlanOffering = {
    import ParentSavingsPlanOffering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.ParentSavingsPlanOffering
      .builder()
      .optionallyWith(offeringId.map(value => value: java.lang.String))(
        _.offeringId
      )
      .optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption)
      .optionallyWith(planType.map(value => value.unwrap))(_.planType)
      .optionallyWith(durationSeconds.map(value => value: java.lang.Long))(
        _.durationSeconds
      )
      .optionallyWith(currency.map(value => value.unwrap))(_.currency)
      .optionallyWith(planDescription.map(value => value: java.lang.String))(
        _.planDescription
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.ParentSavingsPlanOffering.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.ParentSavingsPlanOffering
      .wrap(buildAwsValue())
}
object ParentSavingsPlanOffering {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.ParentSavingsPlanOffering
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.ParentSavingsPlanOffering =
      io.github.vigoo.zioaws.savingsplans.model.ParentSavingsPlanOffering(
        offeringIdValue.map(value => value),
        paymentOptionValue.map(value => value),
        planTypeValue.map(value => value),
        durationSecondsValue.map(value => value),
        currencyValue.map(value => value),
        planDescriptionValue.map(value => value)
      )
    def offeringIdValue: Option[UUID]
    def paymentOptionValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
    ]
    def planTypeValue
        : Option[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType]
    def durationSecondsValue: Option[SavingsPlansDuration]
    def currencyValue
        : Option[io.github.vigoo.zioaws.savingsplans.model.CurrencyCode]
    def planDescriptionValue: Option[SavingsPlanDescription]
    def offeringId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("offeringId", offeringIdValue)
    def paymentOption: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
    ] = AwsError.unwrapOptionField("paymentOption", paymentOptionValue)
    def planType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType
    ] = AwsError.unwrapOptionField("planType", planTypeValue)
    def durationSeconds: ZIO[Any, AwsError, SavingsPlansDuration] =
      AwsError.unwrapOptionField("durationSeconds", durationSecondsValue)
    def currency: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.CurrencyCode
    ] = AwsError.unwrapOptionField("currency", currencyValue)
    def planDescription: ZIO[Any, AwsError, SavingsPlanDescription] =
      AwsError.unwrapOptionField("planDescription", planDescriptionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.ParentSavingsPlanOffering
  ) extends io.github.vigoo.zioaws.savingsplans.model.ParentSavingsPlanOffering.ReadOnly {
    override def offeringIdValue: Option[UUID] =
      scala.Option(impl.offeringId()).map(value => value: UUID)
    override def paymentOptionValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
    ] = scala
      .Option(impl.paymentOption())
      .map(value =>
        io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
          .wrap(value)
      )
    override def planTypeValue
        : Option[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType] =
      scala
        .Option(impl.planType())
        .map(value =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType.wrap(value)
        )
    override def durationSecondsValue: Option[SavingsPlansDuration] = scala
      .Option(impl.durationSeconds())
      .map(value => value: SavingsPlansDuration)
    override def currencyValue
        : Option[io.github.vigoo.zioaws.savingsplans.model.CurrencyCode] = scala
      .Option(impl.currency())
      .map(value =>
        io.github.vigoo.zioaws.savingsplans.model.CurrencyCode.wrap(value)
      )
    override def planDescriptionValue: Option[SavingsPlanDescription] = scala
      .Option(impl.planDescription())
      .map(value => value: SavingsPlanDescription)
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.ParentSavingsPlanOffering
  ): io.github.vigoo.zioaws.savingsplans.model.ParentSavingsPlanOffering.ReadOnly =
    new Wrapper(impl)
}
