package io.github.vigoo.zioaws.savingsplans.model
import io.github.vigoo.zioaws.savingsplans.model.primitives.JsonSafeFilterValueString
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlanRateProperty(
    name: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRatePropertyKey
    ] = None,
    value: Option[JsonSafeFilterValueString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateProperty = {
    import SavingsPlanRateProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateProperty
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateProperty.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateProperty
      .wrap(buildAwsValue())
}
object SavingsPlanRateProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateProperty =
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateProperty(
        nameValue.map(value => value),
        valueValue.map(value => value)
      )
    def nameValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRatePropertyKey
    ]
    def valueValue: Option[JsonSafeFilterValueString]
    def name: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRatePropertyKey
    ] = AwsError.unwrapOptionField("name", nameValue)
    def value: ZIO[Any, AwsError, JsonSafeFilterValueString] =
      AwsError.unwrapOptionField("value", valueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateProperty
  ) extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateProperty.ReadOnly {
    override def nameValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRatePropertyKey
    ] = scala
      .Option(impl.name())
      .map(value =>
        io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRatePropertyKey
          .wrap(value)
      )
    override def valueValue: Option[JsonSafeFilterValueString] =
      scala.Option(impl.value()).map(value => value: JsonSafeFilterValueString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateProperty
  ): io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateProperty.ReadOnly =
    new Wrapper(impl)
}
