package io.github.vigoo.zioaws.savingsplans.model
import io.github.vigoo.zioaws.savingsplans.model.primitives.JsonSafeFilterValueString
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlanOfferingFilterElement(
    name: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingFilterAttribute
    ] = None,
    values: Option[Iterable[JsonSafeFilterValueString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingFilterElement = {
    import SavingsPlanOfferingFilterElement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingFilterElement
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingFilterElement.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingFilterElement
      .wrap(buildAwsValue())
}
object SavingsPlanOfferingFilterElement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingFilterElement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingFilterElement =
      io.github.vigoo.zioaws.savingsplans.model
        .SavingsPlanOfferingFilterElement(
          nameValue.map(value => value),
          valuesValue.map(value => value)
        )
    def nameValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingFilterAttribute
    ]
    def valuesValue: Option[List[JsonSafeFilterValueString]]
    def name: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingFilterAttribute
    ] = AwsError.unwrapOptionField("name", nameValue)
    def values: ZIO[Any, AwsError, List[JsonSafeFilterValueString]] =
      AwsError.unwrapOptionField("values", valuesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingFilterElement
  ) extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingFilterElement.ReadOnly {
    override def nameValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingFilterAttribute
    ] = scala
      .Option(impl.name())
      .map(value =>
        io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingFilterAttribute
          .wrap(value)
      )
    override def valuesValue: Option[List[JsonSafeFilterValueString]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: JsonSafeFilterValueString
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingFilterElement
  ): io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingFilterElement.ReadOnly =
    new Wrapper(impl)
}
