package io.github.vigoo.zioaws.savingsplans.model
import io.github.vigoo.zioaws.savingsplans.model.primitives.{
  SavingsPlanArn,
  TagValue,
  Amount,
  SavingsPlanOfferingId,
  Region,
  SavingsPlanId,
  EC2InstanceFamily,
  TermDurationInSeconds,
  TagKey
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlan(
    offeringId: Option[SavingsPlanOfferingId] = None,
    savingsPlanId: Option[SavingsPlanId] = None,
    savingsPlanArn: Option[SavingsPlanArn] = None,
    description: Option[String] = None,
    start: Option[String] = None,
    end: Option[String] = None,
    state: Option[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanState] =
      None,
    region: Option[Region] = None,
    ec2InstanceFamily: Option[EC2InstanceFamily] = None,
    savingsPlanType: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType
    ] = None,
    paymentOption: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
    ] = None,
    productTypes: Option[
      Iterable[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType]
    ] = None,
    currency: Option[io.github.vigoo.zioaws.savingsplans.model.CurrencyCode] =
      None,
    commitment: Option[Amount] = None,
    upfrontPaymentAmount: Option[Amount] = None,
    recurringPaymentAmount: Option[Amount] = None,
    termDurationInSeconds: Option[TermDurationInSeconds] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlan = {
    import SavingsPlan.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlan
      .builder()
      .optionallyWith(offeringId.map(value => value: java.lang.String))(
        _.offeringId
      )
      .optionallyWith(savingsPlanId.map(value => value: java.lang.String))(
        _.savingsPlanId
      )
      .optionallyWith(savingsPlanArn.map(value => value: java.lang.String))(
        _.savingsPlanArn
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(start.map(value => value: java.lang.String))(_.start)
      .optionallyWith(end.map(value => value: java.lang.String))(_.end)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(ec2InstanceFamily.map(value => value: java.lang.String))(
        _.ec2InstanceFamily
      )
      .optionallyWith(savingsPlanType.map(value => value.unwrap))(
        _.savingsPlanType
      )
      .optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption)
      .optionallyWith(
        productTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.productTypesWithStrings)
      .optionallyWith(currency.map(value => value.unwrap))(_.currency)
      .optionallyWith(commitment.map(value => value: java.lang.String))(
        _.commitment
      )
      .optionallyWith(
        upfrontPaymentAmount.map(value => value: java.lang.String)
      )(_.upfrontPaymentAmount)
      .optionallyWith(
        recurringPaymentAmount.map(value => value: java.lang.String)
      )(_.recurringPaymentAmount)
      .optionallyWith(
        termDurationInSeconds.map(value => value: java.lang.Long)
      )(_.termDurationInSeconds)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.SavingsPlan.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.SavingsPlan.wrap(buildAwsValue())
}
object SavingsPlan {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.SavingsPlan
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.savingsplans.model.SavingsPlan =
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlan(
        offeringIdValue.map(value => value),
        savingsPlanIdValue.map(value => value),
        savingsPlanArnValue.map(value => value),
        descriptionValue.map(value => value),
        startValue.map(value => value),
        endValue.map(value => value),
        stateValue.map(value => value),
        regionValue.map(value => value),
        ec2InstanceFamilyValue.map(value => value),
        savingsPlanTypeValue.map(value => value),
        paymentOptionValue.map(value => value),
        productTypesValue.map(value => value),
        currencyValue.map(value => value),
        commitmentValue.map(value => value),
        upfrontPaymentAmountValue.map(value => value),
        recurringPaymentAmountValue.map(value => value),
        termDurationInSecondsValue.map(value => value),
        tagsValue.map(value => value)
      )
    def offeringIdValue: Option[SavingsPlanOfferingId]
    def savingsPlanIdValue: Option[SavingsPlanId]
    def savingsPlanArnValue: Option[SavingsPlanArn]
    def descriptionValue: Option[String]
    def startValue: Option[String]
    def endValue: Option[String]
    def stateValue
        : Option[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanState]
    def regionValue: Option[Region]
    def ec2InstanceFamilyValue: Option[EC2InstanceFamily]
    def savingsPlanTypeValue
        : Option[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType]
    def paymentOptionValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
    ]
    def productTypesValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType]
    ]
    def currencyValue
        : Option[io.github.vigoo.zioaws.savingsplans.model.CurrencyCode]
    def commitmentValue: Option[Amount]
    def upfrontPaymentAmountValue: Option[Amount]
    def recurringPaymentAmountValue: Option[Amount]
    def termDurationInSecondsValue: Option[TermDurationInSeconds]
    def tagsValue: Option[Map[TagKey, TagValue]]
    def offeringId: ZIO[Any, AwsError, SavingsPlanOfferingId] =
      AwsError.unwrapOptionField("offeringId", offeringIdValue)
    def savingsPlanId: ZIO[Any, AwsError, SavingsPlanId] =
      AwsError.unwrapOptionField("savingsPlanId", savingsPlanIdValue)
    def savingsPlanArn: ZIO[Any, AwsError, SavingsPlanArn] =
      AwsError.unwrapOptionField("savingsPlanArn", savingsPlanArnValue)
    def description: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def start: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("start", startValue)
    def end: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("end", endValue)
    def state: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanState
    ] = AwsError.unwrapOptionField("state", stateValue)
    def region: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", regionValue)
    def ec2InstanceFamily: ZIO[Any, AwsError, EC2InstanceFamily] =
      AwsError.unwrapOptionField("ec2InstanceFamily", ec2InstanceFamilyValue)
    def savingsPlanType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType
    ] = AwsError.unwrapOptionField("savingsPlanType", savingsPlanTypeValue)
    def paymentOption: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
    ] = AwsError.unwrapOptionField("paymentOption", paymentOptionValue)
    def productTypes: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType
    ]] = AwsError.unwrapOptionField("productTypes", productTypesValue)
    def currency: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.CurrencyCode
    ] = AwsError.unwrapOptionField("currency", currencyValue)
    def commitment: ZIO[Any, AwsError, Amount] =
      AwsError.unwrapOptionField("commitment", commitmentValue)
    def upfrontPaymentAmount: ZIO[Any, AwsError, Amount] = AwsError
      .unwrapOptionField("upfrontPaymentAmount", upfrontPaymentAmountValue)
    def recurringPaymentAmount: ZIO[Any, AwsError, Amount] = AwsError
      .unwrapOptionField("recurringPaymentAmount", recurringPaymentAmountValue)
    def termDurationInSeconds: ZIO[Any, AwsError, TermDurationInSeconds] =
      AwsError.unwrapOptionField(
        "termDurationInSeconds",
        termDurationInSecondsValue
      )
    def tags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlan
  ) extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlan.ReadOnly {
    override def offeringIdValue: Option[SavingsPlanOfferingId] =
      scala.Option(impl.offeringId()).map(value => value: SavingsPlanOfferingId)
    override def savingsPlanIdValue: Option[SavingsPlanId] =
      scala.Option(impl.savingsPlanId()).map(value => value: SavingsPlanId)
    override def savingsPlanArnValue: Option[SavingsPlanArn] =
      scala.Option(impl.savingsPlanArn()).map(value => value: SavingsPlanArn)
    override def descriptionValue: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override def startValue: Option[String] =
      scala.Option(impl.start()).map(value => value: String)
    override def endValue: Option[String] =
      scala.Option(impl.end()).map(value => value: String)
    override def stateValue
        : Option[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanState] =
      scala
        .Option(impl.state())
        .map(value =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanState.wrap(value)
        )
    override def regionValue: Option[Region] =
      scala.Option(impl.region()).map(value => value: Region)
    override def ec2InstanceFamilyValue: Option[EC2InstanceFamily] = scala
      .Option(impl.ec2InstanceFamily())
      .map(value => value: EC2InstanceFamily)
    override def savingsPlanTypeValue
        : Option[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType] =
      scala
        .Option(impl.savingsPlanType())
        .map(value =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType.wrap(value)
        )
    override def paymentOptionValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
    ] = scala
      .Option(impl.paymentOption())
      .map(value =>
        io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
          .wrap(value)
      )
    override def productTypesValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType]
    ] = scala
      .Option(impl.productTypes())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType
            .wrap(item)
        }.toList
      )
    override def currencyValue
        : Option[io.github.vigoo.zioaws.savingsplans.model.CurrencyCode] = scala
      .Option(impl.currency())
      .map(value =>
        io.github.vigoo.zioaws.savingsplans.model.CurrencyCode.wrap(value)
      )
    override def commitmentValue: Option[Amount] =
      scala.Option(impl.commitment()).map(value => value: Amount)
    override def upfrontPaymentAmountValue: Option[Amount] =
      scala.Option(impl.upfrontPaymentAmount()).map(value => value: Amount)
    override def recurringPaymentAmountValue: Option[Amount] =
      scala.Option(impl.recurringPaymentAmount()).map(value => value: Amount)
    override def termDurationInSecondsValue: Option[TermDurationInSeconds] =
      scala
        .Option(impl.termDurationInSeconds())
        .map(value => value: TermDurationInSeconds)
    override def tagsValue: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: TagKey) -> (value: TagValue)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlan
  ): io.github.vigoo.zioaws.savingsplans.model.SavingsPlan.ReadOnly =
    new Wrapper(impl)
}
