package io.github.vigoo.zioaws.savingsplans.model
import java.lang.Integer
import io.github.vigoo.zioaws.savingsplans.model.primitives.{
  SavingsPlanRateOperation,
  SavingsPlanRateUsageType,
  PaginationToken,
  UUID,
  PageSize
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSavingsPlansOfferingRatesRequest(
    savingsPlanOfferingIds: Option[Iterable[UUID]] = None,
    savingsPlanPaymentOptions: Option[Iterable[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
    ]] = None,
    savingsPlanTypes: Option[
      Iterable[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType]
    ] = None,
    products: Option[
      Iterable[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType]
    ] = None,
    serviceCodes: Option[Iterable[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateServiceCode
    ]] = None,
    usageTypes: Option[Iterable[SavingsPlanRateUsageType]] = None,
    operations: Option[Iterable[SavingsPlanRateOperation]] = None,
    filters: Option[Iterable[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateFilterElement
    ]] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[PageSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest = {
    import DescribeSavingsPlansOfferingRatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest
      .builder()
      .optionallyWith(
        savingsPlanOfferingIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.savingsPlanOfferingIds)
      .optionallyWith(
        savingsPlanPaymentOptions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.savingsPlanPaymentOptionsWithStrings)
      .optionallyWith(
        savingsPlanTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.savingsPlanTypesWithStrings)
      .optionallyWith(
        products.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.productsWithStrings)
      .optionallyWith(
        serviceCodes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.serviceCodesWithStrings)
      .optionallyWith(
        usageTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.usageTypes)
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.operations)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest
      .wrap(buildAwsValue())
}
object DescribeSavingsPlansOfferingRatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest =
      io.github.vigoo.zioaws.savingsplans.model
        .DescribeSavingsPlansOfferingRatesRequest(
          savingsPlanOfferingIdsValue.map(value => value),
          savingsPlanPaymentOptionsValue.map(value => value),
          savingsPlanTypesValue.map(value => value),
          productsValue.map(value => value),
          serviceCodesValue.map(value => value),
          usageTypesValue.map(value => value),
          operationsValue.map(value => value),
          filtersValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value),
          maxResultsValue.map(value => value)
        )
    def savingsPlanOfferingIdsValue: Option[List[UUID]]
    def savingsPlanPaymentOptionsValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption]
    ]
    def savingsPlanTypesValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType]
    ]
    def productsValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType]
    ]
    def serviceCodesValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateServiceCode]
    ]
    def usageTypesValue: Option[List[SavingsPlanRateUsageType]]
    def operationsValue: Option[List[SavingsPlanRateOperation]]
    def filtersValue: Option[List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateFilterElement.ReadOnly
    ]]
    def nextTokenValue: Option[PaginationToken]
    def maxResultsValue: Option[PageSize]
    def savingsPlanOfferingIds: ZIO[Any, AwsError, List[UUID]] = AwsError
      .unwrapOptionField("savingsPlanOfferingIds", savingsPlanOfferingIdsValue)
    def savingsPlanPaymentOptions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
    ]] = AwsError.unwrapOptionField(
      "savingsPlanPaymentOptions",
      savingsPlanPaymentOptionsValue
    )
    def savingsPlanTypes: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType
    ]] = AwsError.unwrapOptionField("savingsPlanTypes", savingsPlanTypesValue)
    def products: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType
    ]] = AwsError.unwrapOptionField("products", productsValue)
    def serviceCodes: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateServiceCode
    ]] = AwsError.unwrapOptionField("serviceCodes", serviceCodesValue)
    def usageTypes: ZIO[Any, AwsError, List[SavingsPlanRateUsageType]] =
      AwsError.unwrapOptionField("usageTypes", usageTypesValue)
    def operations: ZIO[Any, AwsError, List[SavingsPlanRateOperation]] =
      AwsError.unwrapOptionField("operations", operationsValue)
    def filters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateFilterElement.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filtersValue)
    def nextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest
  ) extends io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest.ReadOnly {
    override def savingsPlanOfferingIdsValue: Option[List[UUID]] = scala
      .Option(impl.savingsPlanOfferingIds())
      .map(value =>
        value.asScala.map { item =>
          item: UUID
        }.toList
      )
    override def savingsPlanPaymentOptionsValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption]
    ] = scala
      .Option(impl.savingsPlanPaymentOptions())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
            .wrap(item)
        }.toList
      )
    override def savingsPlanTypesValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType]
    ] = scala
      .Option(impl.savingsPlanTypes())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType.wrap(item)
        }.toList
      )
    override def productsValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType]
    ] = scala
      .Option(impl.products())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType
            .wrap(item)
        }.toList
      )
    override def serviceCodesValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateServiceCode]
    ] = scala
      .Option(impl.serviceCodes())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateServiceCode
            .wrap(item)
        }.toList
      )
    override def usageTypesValue: Option[List[SavingsPlanRateUsageType]] = scala
      .Option(impl.usageTypes())
      .map(value =>
        value.asScala.map { item =>
          item: SavingsPlanRateUsageType
        }.toList
      )
    override def operationsValue: Option[List[SavingsPlanRateOperation]] = scala
      .Option(impl.operations())
      .map(value =>
        value.asScala.map { item =>
          item: SavingsPlanRateOperation
        }.toList
      )
    override def filtersValue: Option[List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateFilterElement.ReadOnly
    ]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateFilterElement
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[PaginationToken] =
      scala.Option(impl.nextToken()).map(value => value: PaginationToken)
    override def maxResultsValue: Option[PageSize] =
      scala.Option(impl.maxResults()).map(value => value: PageSize)
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest
  ): io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest.ReadOnly =
    new Wrapper(impl)
}
