package io.github.vigoo.zioaws.savingsplans.model
import io.github.vigoo.zioaws.savingsplans.model.primitives.{
  PaginationToken,
  SavingsPlanId
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSavingsPlanRatesResponse(
    savingsPlanId: Option[SavingsPlanId] = None,
    searchResults: Option[
      Iterable[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRate]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesResponse = {
    import DescribeSavingsPlanRatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesResponse
      .builder()
      .optionallyWith(savingsPlanId.map(value => value: java.lang.String))(
        _.savingsPlanId
      )
      .optionallyWith(
        searchResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.searchResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesResponse.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesResponse
      .wrap(buildAwsValue())
}
object DescribeSavingsPlanRatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesResponse =
      io.github.vigoo.zioaws.savingsplans.model
        .DescribeSavingsPlanRatesResponse(
          savingsPlanIdValue.map(value => value),
          searchResultsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value)
        )
    def savingsPlanIdValue: Option[SavingsPlanId]
    def searchResultsValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRate.ReadOnly]
    ]
    def nextTokenValue: Option[PaginationToken]
    def savingsPlanId: ZIO[Any, AwsError, SavingsPlanId] =
      AwsError.unwrapOptionField("savingsPlanId", savingsPlanIdValue)
    def searchResults: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRate.ReadOnly
    ]] = AwsError.unwrapOptionField("searchResults", searchResultsValue)
    def nextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesResponse
  ) extends io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesResponse.ReadOnly {
    override def savingsPlanIdValue: Option[SavingsPlanId] =
      scala.Option(impl.savingsPlanId()).map(value => value: SavingsPlanId)
    override def searchResultsValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRate.ReadOnly]
    ] = scala
      .Option(impl.searchResults())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRate.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[PaginationToken] =
      scala.Option(impl.nextToken()).map(value => value: PaginationToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesResponse
  ): io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesResponse.ReadOnly =
    new Wrapper(impl)
}
