package io.github.vigoo.zioaws.savingsplans.model
import io.github.vigoo.zioaws.savingsplans.model.primitives.{
  TagValue,
  TagKey,
  SavingsPlanArn
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: SavingsPlanArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.TagResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.TagResourceRequest.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.TagResourceRequest
      .wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.savingsplans.model.TagResourceRequest =
      io.github.vigoo.zioaws.savingsplans.model
        .TagResourceRequest(resourceArnValue, tagsValue)
    def resourceArnValue: SavingsPlanArn
    def tagsValue: Map[TagKey, TagValue]
    def resourceArn: ZIO[Any, Nothing, SavingsPlanArn] =
      ZIO.succeed(resourceArnValue)
    def tags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.TagResourceRequest
  ) extends io.github.vigoo.zioaws.savingsplans.model.TagResourceRequest.ReadOnly {
    override def resourceArnValue: SavingsPlanArn =
      impl.resourceArn(): SavingsPlanArn
    override def tagsValue: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        (key: TagKey) -> (value: TagValue)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.TagResourceRequest
  ): io.github.vigoo.zioaws.savingsplans.model.TagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
