package io.github.vigoo.zioaws.savingsplans.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlanFilter(
    name: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlansFilterName
    ] = None,
    values: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlanFilter = {
    import SavingsPlanFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanFilter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.SavingsPlanFilter.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.SavingsPlanFilter
      .wrap(buildAwsValue())
}
object SavingsPlanFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.savingsplans.model.SavingsPlanFilter =
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanFilter(
        nameValue.map(value => value),
        valuesValue.map(value => value)
      )
    def nameValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlansFilterName
    ]
    def valuesValue: Option[List[String]]
    def name: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlansFilterName
    ] = AwsError.unwrapOptionField("name", nameValue)
    def values: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("values", valuesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanFilter
  ) extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlanFilter.ReadOnly {
    override def nameValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlansFilterName
    ] = scala
      .Option(impl.name())
      .map(value =>
        io.github.vigoo.zioaws.savingsplans.model.SavingsPlansFilterName
          .wrap(value)
      )
    override def valuesValue: Option[List[String]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanFilter
  ): io.github.vigoo.zioaws.savingsplans.model.SavingsPlanFilter.ReadOnly =
    new Wrapper(impl)
}
