package io.github.vigoo.zioaws.savingsplans.model
import io.github.vigoo.zioaws.savingsplans.model.primitives.PaginationToken
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSavingsPlansResponse(
    savingsPlans: Option[
      Iterable[io.github.vigoo.zioaws.savingsplans.model.SavingsPlan]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansResponse = {
    import DescribeSavingsPlansResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansResponse
      .builder()
      .optionallyWith(
        savingsPlans.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.savingsPlans)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansResponse.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansResponse
      .wrap(buildAwsValue())
}
object DescribeSavingsPlansResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansResponse =
      io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansResponse(
        savingsPlansValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def savingsPlansValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlan.ReadOnly]
    ]
    def nextTokenValue: Option[PaginationToken]
    def savingsPlans: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlan.ReadOnly
    ]] = AwsError.unwrapOptionField("savingsPlans", savingsPlansValue)
    def nextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansResponse
  ) extends io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansResponse.ReadOnly {
    override def savingsPlansValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlan.ReadOnly]
    ] = scala
      .Option(impl.savingsPlans())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlan.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[PaginationToken] =
      scala.Option(impl.nextToken()).map(value => value: PaginationToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansResponse
  ): io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansResponse.ReadOnly =
    new Wrapper(impl)
}
