package io.github.vigoo.zioaws.savingsplans.model
import io.github.vigoo.zioaws.savingsplans.model.primitives.PaginationToken
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSavingsPlansOfferingsResponse(
    searchResults: Option[
      Iterable[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOffering]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsResponse = {
    import DescribeSavingsPlansOfferingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsResponse
      .builder()
      .optionallyWith(
        searchResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.searchResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsResponse.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsResponse
      .wrap(buildAwsValue())
}
object DescribeSavingsPlansOfferingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsResponse =
      io.github.vigoo.zioaws.savingsplans.model
        .DescribeSavingsPlansOfferingsResponse(
          searchResultsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value)
        )
    def searchResultsValue: Option[List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOffering.ReadOnly
    ]]
    def nextTokenValue: Option[PaginationToken]
    def searchResults: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOffering.ReadOnly
    ]] = AwsError.unwrapOptionField("searchResults", searchResultsValue)
    def nextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsResponse
  ) extends io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsResponse.ReadOnly {
    override def searchResultsValue: Option[List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOffering.ReadOnly
    ]] = scala
      .Option(impl.searchResults())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOffering
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[PaginationToken] =
      scala.Option(impl.nextToken()).map(value => value: PaginationToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsResponse
  ): io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsResponse.ReadOnly =
    new Wrapper(impl)
}
