package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
sealed trait SavingsPlanType {
  def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanType
}
object SavingsPlanType {
  def wrap(
      value: software.amazon.awssdk.services.savingsplans.model.SavingsPlanType
  ): io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType = value match {
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanType.COMPUTE =>
      val r = Compute
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanType.EC2_INSTANCE =>
      val r = EC2Instance
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanType.SAGE_MAKER =>
      val r = SageMaker
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanType =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanType.UNKNOWN_TO_SDK_VERSION
  }
  case object Compute
      extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanType =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanType.COMPUTE
  }
  case object EC2Instance
      extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanType =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanType.EC2_INSTANCE
  }
  case object SageMaker
      extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanType =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanType.SAGE_MAKER
  }
}
