package io.github.vigoo.zioaws.savingsplans.model
import io.github.vigoo.zioaws.savingsplans.model.primitives.{
  SavingsPlansDuration,
  SavingsPlanUsageType,
  UUID,
  SavingsPlanOperation,
  SavingsPlanServiceCode,
  SavingsPlanDescription
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlanOffering(
    offeringId: Option[UUID] = None,
    productTypes: Option[
      Iterable[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType]
    ] = None,
    planType: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType
    ] = None,
    description: Option[SavingsPlanDescription] = None,
    paymentOption: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
    ] = None,
    durationSeconds: Option[SavingsPlansDuration] = None,
    currency: Option[io.github.vigoo.zioaws.savingsplans.model.CurrencyCode] =
      None,
    serviceCode: Option[SavingsPlanServiceCode] = None,
    usageType: Option[SavingsPlanUsageType] = None,
    operation: Option[SavingsPlanOperation] = None,
    properties: Option[Iterable[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingProperty
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlanOffering = {
    import SavingsPlanOffering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOffering
      .builder()
      .optionallyWith(offeringId.map(value => value: java.lang.String))(
        _.offeringId
      )
      .optionallyWith(
        productTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.productTypesWithStrings)
      .optionallyWith(planType.map(value => value.unwrap))(_.planType)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption)
      .optionallyWith(durationSeconds.map(value => value: java.lang.Long))(
        _.durationSeconds
      )
      .optionallyWith(currency.map(value => value.unwrap))(_.currency)
      .optionallyWith(serviceCode.map(value => value: java.lang.String))(
        _.serviceCode
      )
      .optionallyWith(usageType.map(value => value: java.lang.String))(
        _.usageType
      )
      .optionallyWith(operation.map(value => value: java.lang.String))(
        _.operation
      )
      .optionallyWith(
        properties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.properties)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOffering.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOffering
      .wrap(buildAwsValue())
}
object SavingsPlanOffering {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOffering
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOffering =
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOffering(
        offeringIdValue.map(value => value),
        productTypesValue.map(value => value),
        planTypeValue.map(value => value),
        descriptionValue.map(value => value),
        paymentOptionValue.map(value => value),
        durationSecondsValue.map(value => value),
        currencyValue.map(value => value),
        serviceCodeValue.map(value => value),
        usageTypeValue.map(value => value),
        operationValue.map(value => value),
        propertiesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def offeringIdValue: Option[UUID]
    def productTypesValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType]
    ]
    def planTypeValue
        : Option[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType]
    def descriptionValue: Option[SavingsPlanDescription]
    def paymentOptionValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
    ]
    def durationSecondsValue: Option[SavingsPlansDuration]
    def currencyValue
        : Option[io.github.vigoo.zioaws.savingsplans.model.CurrencyCode]
    def serviceCodeValue: Option[SavingsPlanServiceCode]
    def usageTypeValue: Option[SavingsPlanUsageType]
    def operationValue: Option[SavingsPlanOperation]
    def propertiesValue: Option[List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingProperty.ReadOnly
    ]]
    def offeringId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("offeringId", offeringIdValue)
    def productTypes: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType
    ]] = AwsError.unwrapOptionField("productTypes", productTypesValue)
    def planType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType
    ] = AwsError.unwrapOptionField("planType", planTypeValue)
    def description: ZIO[Any, AwsError, SavingsPlanDescription] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def paymentOption: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
    ] = AwsError.unwrapOptionField("paymentOption", paymentOptionValue)
    def durationSeconds: ZIO[Any, AwsError, SavingsPlansDuration] =
      AwsError.unwrapOptionField("durationSeconds", durationSecondsValue)
    def currency: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.CurrencyCode
    ] = AwsError.unwrapOptionField("currency", currencyValue)
    def serviceCode: ZIO[Any, AwsError, SavingsPlanServiceCode] =
      AwsError.unwrapOptionField("serviceCode", serviceCodeValue)
    def usageType: ZIO[Any, AwsError, SavingsPlanUsageType] =
      AwsError.unwrapOptionField("usageType", usageTypeValue)
    def operation: ZIO[Any, AwsError, SavingsPlanOperation] =
      AwsError.unwrapOptionField("operation", operationValue)
    def properties: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("properties", propertiesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOffering
  ) extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOffering.ReadOnly {
    override def offeringIdValue: Option[UUID] =
      scala.Option(impl.offeringId()).map(value => value: UUID)
    override def productTypesValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType]
    ] = scala
      .Option(impl.productTypes())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType
            .wrap(item)
        }.toList
      )
    override def planTypeValue
        : Option[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType] =
      scala
        .Option(impl.planType())
        .map(value =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType.wrap(value)
        )
    override def descriptionValue: Option[SavingsPlanDescription] = scala
      .Option(impl.description())
      .map(value => value: SavingsPlanDescription)
    override def paymentOptionValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
    ] = scala
      .Option(impl.paymentOption())
      .map(value =>
        io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
          .wrap(value)
      )
    override def durationSecondsValue: Option[SavingsPlansDuration] = scala
      .Option(impl.durationSeconds())
      .map(value => value: SavingsPlansDuration)
    override def currencyValue
        : Option[io.github.vigoo.zioaws.savingsplans.model.CurrencyCode] = scala
      .Option(impl.currency())
      .map(value =>
        io.github.vigoo.zioaws.savingsplans.model.CurrencyCode.wrap(value)
      )
    override def serviceCodeValue: Option[SavingsPlanServiceCode] = scala
      .Option(impl.serviceCode())
      .map(value => value: SavingsPlanServiceCode)
    override def usageTypeValue: Option[SavingsPlanUsageType] =
      scala.Option(impl.usageType()).map(value => value: SavingsPlanUsageType)
    override def operationValue: Option[SavingsPlanOperation] =
      scala.Option(impl.operation()).map(value => value: SavingsPlanOperation)
    override def propertiesValue: Option[List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingProperty.ReadOnly
    ]] = scala
      .Option(impl.properties())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingProperty
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOffering
  ): io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOffering.ReadOnly =
    new Wrapper(impl)
}
