package io.github.vigoo.zioaws.savingsplans.model
import io.github.vigoo.zioaws.savingsplans.model.primitives.SavingsPlanId
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateSavingsPlanResponse(
    savingsPlanId: Option[SavingsPlanId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanResponse = {
    import CreateSavingsPlanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanResponse
      .builder()
      .optionallyWith(savingsPlanId.map(value => value: java.lang.String))(
        _.savingsPlanId
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanResponse.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanResponse
      .wrap(buildAwsValue())
}
object CreateSavingsPlanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanResponse =
      io.github.vigoo.zioaws.savingsplans.model
        .CreateSavingsPlanResponse(savingsPlanIdValue.map(value => value))
    def savingsPlanIdValue: Option[SavingsPlanId]
    def savingsPlanId: ZIO[Any, AwsError, SavingsPlanId] =
      AwsError.unwrapOptionField("savingsPlanId", savingsPlanIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanResponse
  ) extends io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanResponse.ReadOnly {
    override def savingsPlanIdValue: Option[SavingsPlanId] =
      scala.Option(impl.savingsPlanId()).map(value => value: SavingsPlanId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanResponse
  ): io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanResponse.ReadOnly =
    new Wrapper(impl)
}
