package io.github.vigoo.zioaws.savingsplans.model
import io.github.vigoo.zioaws.savingsplans.model.primitives.{
  TagValue,
  DateTime,
  Amount,
  SavingsPlanOfferingId,
  ClientToken,
  TagKey
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateSavingsPlanRequest(
    savingsPlanOfferingId: SavingsPlanOfferingId,
    commitment: Amount,
    upfrontPaymentAmount: Option[Amount] = None,
    purchaseTime: Option[DateTime] = None,
    clientToken: Option[ClientToken] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest = {
    import CreateSavingsPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest
      .builder()
      .savingsPlanOfferingId(savingsPlanOfferingId: java.lang.String)
      .commitment(commitment: java.lang.String)
      .optionallyWith(
        upfrontPaymentAmount.map(value => value: java.lang.String)
      )(_.upfrontPaymentAmount)
      .optionallyWith(purchaseTime.map(value => value: Instant))(_.purchaseTime)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanRequest.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanRequest
      .wrap(buildAwsValue())
}
object CreateSavingsPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanRequest =
      io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanRequest(
        savingsPlanOfferingIdValue,
        commitmentValue,
        upfrontPaymentAmountValue.map(value => value),
        purchaseTimeValue.map(value => value),
        clientTokenValue.map(value => value),
        tagsValue.map(value => value)
      )
    def savingsPlanOfferingIdValue: SavingsPlanOfferingId
    def commitmentValue: Amount
    def upfrontPaymentAmountValue: Option[Amount]
    def purchaseTimeValue: Option[DateTime]
    def clientTokenValue: Option[ClientToken]
    def tagsValue: Option[Map[TagKey, TagValue]]
    def savingsPlanOfferingId: ZIO[Any, Nothing, SavingsPlanOfferingId] =
      ZIO.succeed(savingsPlanOfferingIdValue)
    def commitment: ZIO[Any, Nothing, Amount] = ZIO.succeed(commitmentValue)
    def upfrontPaymentAmount: ZIO[Any, AwsError, Amount] = AwsError
      .unwrapOptionField("upfrontPaymentAmount", upfrontPaymentAmountValue)
    def purchaseTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("purchaseTime", purchaseTimeValue)
    def clientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientTokenValue)
    def tags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest
  ) extends io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanRequest.ReadOnly {
    override def savingsPlanOfferingIdValue: SavingsPlanOfferingId =
      impl.savingsPlanOfferingId(): SavingsPlanOfferingId
    override def commitmentValue: Amount = impl.commitment(): Amount
    override def upfrontPaymentAmountValue: Option[Amount] =
      scala.Option(impl.upfrontPaymentAmount()).map(value => value: Amount)
    override def purchaseTimeValue: Option[DateTime] =
      scala.Option(impl.purchaseTime()).map(value => value: DateTime)
    override def clientTokenValue: Option[ClientToken] =
      scala.Option(impl.clientToken()).map(value => value: ClientToken)
    override def tagsValue: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: TagKey) -> (value: TagValue)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest
  ): io.github.vigoo.zioaws.savingsplans.model.CreateSavingsPlanRequest.ReadOnly =
    new Wrapper(impl)
}
