package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class SavingsPlanOfferingRate(savingsPlanOffering: scala.Option[ParentSavingsPlanOffering] = None, rate: scala.Option[primitives.SavingsPlanRatePricePerUnit] = None, unit: scala.Option[SavingsPlanRateUnit] = None, productType: scala.Option[SavingsPlanProductType] = None, serviceCode: scala.Option[SavingsPlanRateServiceCode] = None, usageType: scala.Option[primitives.SavingsPlanRateUsageType] = None, operation: scala.Option[primitives.SavingsPlanRateOperation] = None, properties: scala.Option[Iterable[SavingsPlanOfferingRateProperty]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRate = {
    import SavingsPlanOfferingRate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRate.builder().optionallyWith(savingsPlanOffering.map(value => value.buildAwsValue()))(_.savingsPlanOffering).optionallyWith(rate.map(value => value: java.lang.String))(_.rate).optionallyWith(unit.map(value => value.unwrap))(_.unit).optionallyWith(productType.map(value => value.unwrap))(_.productType).optionallyWith(serviceCode.map(value => value.unwrap))(_.serviceCode).optionallyWith(usageType.map(value => value: java.lang.String))(_.usageType).optionallyWith(operation.map(value => value: java.lang.String))(_.operation).optionallyWith(properties.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.properties).build()
  }
  def asReadOnly: SavingsPlanOfferingRate.ReadOnly = SavingsPlanOfferingRate.wrap(buildAwsValue())
}
object SavingsPlanOfferingRate {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRate] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: SavingsPlanOfferingRate = SavingsPlanOfferingRate(savingsPlanOfferingValue.map(value => value.editable), rateValue.map(value => value), unitValue.map(value => value), productTypeValue.map(value => value), serviceCodeValue.map(value => value), usageTypeValue.map(value => value), operationValue.map(value => value), propertiesValue.map(value => value.map { item => 
      item.editable
    }))
    def savingsPlanOfferingValue: scala.Option[ParentSavingsPlanOffering.ReadOnly]
    def rateValue: scala.Option[primitives.SavingsPlanRatePricePerUnit]
    def unitValue: scala.Option[SavingsPlanRateUnit]
    def productTypeValue: scala.Option[SavingsPlanProductType]
    def serviceCodeValue: scala.Option[SavingsPlanRateServiceCode]
    def usageTypeValue: scala.Option[primitives.SavingsPlanRateUsageType]
    def operationValue: scala.Option[primitives.SavingsPlanRateOperation]
    def propertiesValue: scala.Option[List[SavingsPlanOfferingRateProperty.ReadOnly]]
    def savingsPlanOffering: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ParentSavingsPlanOffering.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savingsPlanOffering", savingsPlanOfferingValue)
    def rate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SavingsPlanRatePricePerUnit] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("rate", rateValue)
    def unit: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlanRateUnit] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("unit", unitValue)
    def productType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlanProductType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("productType", productTypeValue)
    def serviceCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlanRateServiceCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("serviceCode", serviceCodeValue)
    def usageType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SavingsPlanRateUsageType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("usageType", usageTypeValue)
    def operation: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SavingsPlanRateOperation] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("operation", operationValue)
    def properties: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SavingsPlanOfferingRateProperty.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("properties", propertiesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRate) extends SavingsPlanOfferingRate.ReadOnly {
    override def savingsPlanOfferingValue: scala.Option[ParentSavingsPlanOffering.ReadOnly] = scala.Option(impl.savingsPlanOffering()).map(value => ParentSavingsPlanOffering.wrap(value))
    override def rateValue: scala.Option[primitives.SavingsPlanRatePricePerUnit] = scala.Option(impl.rate()).map(value => value: primitives.SavingsPlanRatePricePerUnit)
    override def unitValue: scala.Option[SavingsPlanRateUnit] = scala.Option(impl.unit()).map(value => SavingsPlanRateUnit.wrap(value))
    override def productTypeValue: scala.Option[SavingsPlanProductType] = scala.Option(impl.productType()).map(value => SavingsPlanProductType.wrap(value))
    override def serviceCodeValue: scala.Option[SavingsPlanRateServiceCode] = scala.Option(impl.serviceCode()).map(value => SavingsPlanRateServiceCode.wrap(value))
    override def usageTypeValue: scala.Option[primitives.SavingsPlanRateUsageType] = scala.Option(impl.usageType()).map(value => value: primitives.SavingsPlanRateUsageType)
    override def operationValue: scala.Option[primitives.SavingsPlanRateOperation] = scala.Option(impl.operation()).map(value => value: primitives.SavingsPlanRateOperation)
    override def propertiesValue: scala.Option[List[SavingsPlanOfferingRateProperty.ReadOnly]] = scala.Option(impl.properties()).map(value => value.asScala.map { item => 
      SavingsPlanOfferingRateProperty.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRate): ReadOnly = new Wrapper(impl)
}