package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ParentSavingsPlanOffering(offeringId: scala.Option[primitives.UUID] = None, paymentOption: scala.Option[SavingsPlanPaymentOption] = None, planType: scala.Option[SavingsPlanType] = None, durationSeconds: scala.Option[primitives.SavingsPlansDuration] = None, currency: scala.Option[CurrencyCode] = None, planDescription: scala.Option[primitives.SavingsPlanDescription] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.savingsplans.model.ParentSavingsPlanOffering = {
    import ParentSavingsPlanOffering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.ParentSavingsPlanOffering.builder().optionallyWith(offeringId.map(value => value: java.lang.String))(_.offeringId).optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption).optionallyWith(planType.map(value => value.unwrap))(_.planType).optionallyWith(durationSeconds.map(value => value: java.lang.Long))(_.durationSeconds).optionallyWith(currency.map(value => value.unwrap))(_.currency).optionallyWith(planDescription.map(value => value: java.lang.String))(_.planDescription).build()
  }
  def asReadOnly: ParentSavingsPlanOffering.ReadOnly = ParentSavingsPlanOffering.wrap(buildAwsValue())
}
object ParentSavingsPlanOffering {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.savingsplans.model.ParentSavingsPlanOffering] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ParentSavingsPlanOffering = ParentSavingsPlanOffering(offeringIdValue.map(value => value), paymentOptionValue.map(value => value), planTypeValue.map(value => value), durationSecondsValue.map(value => value), currencyValue.map(value => value), planDescriptionValue.map(value => value))
    def offeringIdValue: scala.Option[primitives.UUID]
    def paymentOptionValue: scala.Option[SavingsPlanPaymentOption]
    def planTypeValue: scala.Option[SavingsPlanType]
    def durationSecondsValue: scala.Option[primitives.SavingsPlansDuration]
    def currencyValue: scala.Option[CurrencyCode]
    def planDescriptionValue: scala.Option[primitives.SavingsPlanDescription]
    def offeringId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.UUID] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("offeringId", offeringIdValue)
    def paymentOption: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlanPaymentOption] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("paymentOption", paymentOptionValue)
    def planType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlanType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("planType", planTypeValue)
    def durationSeconds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SavingsPlansDuration] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("durationSeconds", durationSecondsValue)
    def currency: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CurrencyCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currency", currencyValue)
    def planDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SavingsPlanDescription] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("planDescription", planDescriptionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.savingsplans.model.ParentSavingsPlanOffering) extends ParentSavingsPlanOffering.ReadOnly {
    override def offeringIdValue: scala.Option[primitives.UUID] = scala.Option(impl.offeringId()).map(value => value: primitives.UUID)
    override def paymentOptionValue: scala.Option[SavingsPlanPaymentOption] = scala.Option(impl.paymentOption()).map(value => SavingsPlanPaymentOption.wrap(value))
    override def planTypeValue: scala.Option[SavingsPlanType] = scala.Option(impl.planType()).map(value => SavingsPlanType.wrap(value))
    override def durationSecondsValue: scala.Option[primitives.SavingsPlansDuration] = scala.Option(impl.durationSeconds()).map(value => value: primitives.SavingsPlansDuration)
    override def currencyValue: scala.Option[CurrencyCode] = scala.Option(impl.currency()).map(value => CurrencyCode.wrap(value))
    override def planDescriptionValue: scala.Option[primitives.SavingsPlanDescription] = scala.Option(impl.planDescription()).map(value => value: primitives.SavingsPlanDescription)
  }
  def wrap(impl: software.amazon.awssdk.services.savingsplans.model.ParentSavingsPlanOffering): ReadOnly = new Wrapper(impl)
}