package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeSavingsPlansRequest(savingsPlanArns: scala.Option[Iterable[primitives.SavingsPlanArn]] = None, savingsPlanIds: scala.Option[Iterable[primitives.SavingsPlanId]] = None, nextToken: scala.Option[primitives.PaginationToken] = None, maxResults: scala.Option[primitives.MaxResults] = None, states: scala.Option[Iterable[SavingsPlanState]] = None, filters: scala.Option[Iterable[SavingsPlanFilter]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest = {
    import DescribeSavingsPlansRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest.builder().optionallyWith(savingsPlanArns.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.savingsPlanArns).optionallyWith(savingsPlanIds.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.savingsPlanIds).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).optionallyWith(states.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.statesWithStrings).optionallyWith(filters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.filters).build()
  }
  def asReadOnly: DescribeSavingsPlansRequest.ReadOnly = DescribeSavingsPlansRequest.wrap(buildAwsValue())
}
object DescribeSavingsPlansRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeSavingsPlansRequest = DescribeSavingsPlansRequest(savingsPlanArnsValue.map(value => value), savingsPlanIdsValue.map(value => value), nextTokenValue.map(value => value), maxResultsValue.map(value => value), statesValue.map(value => value), filtersValue.map(value => value.map { item => 
      item.editable
    }))
    def savingsPlanArnsValue: scala.Option[List[primitives.SavingsPlanArn]]
    def savingsPlanIdsValue: scala.Option[List[primitives.SavingsPlanId]]
    def nextTokenValue: scala.Option[primitives.PaginationToken]
    def maxResultsValue: scala.Option[primitives.MaxResults]
    def statesValue: scala.Option[List[SavingsPlanState]]
    def filtersValue: scala.Option[List[SavingsPlanFilter.ReadOnly]]
    def savingsPlanArns: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.SavingsPlanArn]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savingsPlanArns", savingsPlanArnsValue)
    def savingsPlanIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.SavingsPlanId]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savingsPlanIds", savingsPlanIdsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PaginationToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResults] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def states: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SavingsPlanState]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("states", statesValue)
    def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SavingsPlanFilter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest) extends DescribeSavingsPlansRequest.ReadOnly {
    override def savingsPlanArnsValue: scala.Option[List[primitives.SavingsPlanArn]] = scala.Option(impl.savingsPlanArns()).map(value => value.asScala.map { item => 
      item: primitives.SavingsPlanArn
    }.toList)
    override def savingsPlanIdsValue: scala.Option[List[primitives.SavingsPlanId]] = scala.Option(impl.savingsPlanIds()).map(value => value.asScala.map { item => 
      item: primitives.SavingsPlanId
    }.toList)
    override def nextTokenValue: scala.Option[primitives.PaginationToken] = scala.Option(impl.nextToken()).map(value => value: primitives.PaginationToken)
    override def maxResultsValue: scala.Option[primitives.MaxResults] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResults)
    override def statesValue: scala.Option[List[SavingsPlanState]] = scala.Option(impl.states()).map(value => value.asScala.map { item => 
      SavingsPlanState.wrap(item)
    }.toList)
    override def filtersValue: scala.Option[List[SavingsPlanFilter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
      SavingsPlanFilter.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest): ReadOnly = new Wrapper(impl)
}