package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait SavingsPlanOfferingPropertyKey { def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingPropertyKey }
object SavingsPlanOfferingPropertyKey {
  def wrap(value: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingPropertyKey): SavingsPlanOfferingPropertyKey = value match {
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingPropertyKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingPropertyKey.REGION =>
      val r = region
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingPropertyKey.INSTANCE_FAMILY =>
      val r = instanceFamily
      r
  }
  case object unknownToSdkVersion extends SavingsPlanOfferingPropertyKey { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingPropertyKey = software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingPropertyKey.UNKNOWN_TO_SDK_VERSION }
  case object region extends SavingsPlanOfferingPropertyKey { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingPropertyKey = software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingPropertyKey.REGION }
  case object instanceFamily extends SavingsPlanOfferingPropertyKey { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingPropertyKey = software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingPropertyKey.INSTANCE_FAMILY }
}