package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class SavingsPlan(offeringId: scala.Option[primitives.SavingsPlanOfferingId] = None, savingsPlanId: scala.Option[primitives.SavingsPlanId] = None, savingsPlanArn: scala.Option[primitives.SavingsPlanArn] = None, description: scala.Option[String] = None, start: scala.Option[String] = None, end: scala.Option[String] = None, state: scala.Option[SavingsPlanState] = None, region: scala.Option[primitives.Region] = None, ec2InstanceFamily: scala.Option[primitives.EC2InstanceFamily] = None, savingsPlanType: scala.Option[SavingsPlanType] = None, paymentOption: scala.Option[SavingsPlanPaymentOption] = None, productTypes: scala.Option[Iterable[SavingsPlanProductType]] = None, currency: scala.Option[CurrencyCode] = None, commitment: scala.Option[primitives.Amount] = None, upfrontPaymentAmount: scala.Option[primitives.Amount] = None, recurringPaymentAmount: scala.Option[primitives.Amount] = None, termDurationInSeconds: scala.Option[primitives.TermDurationInSeconds] = None, tags: scala.Option[Map[primitives.TagKey, primitives.TagValue]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.savingsplans.model.SavingsPlan = {
    import SavingsPlan.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlan.builder().optionallyWith(offeringId.map(value => value: java.lang.String))(_.offeringId).optionallyWith(savingsPlanId.map(value => value: java.lang.String))(_.savingsPlanId).optionallyWith(savingsPlanArn.map(value => value: java.lang.String))(_.savingsPlanArn).optionallyWith(description.map(value => value: java.lang.String))(_.description).optionallyWith(start.map(value => value: java.lang.String))(_.start).optionallyWith(end.map(value => value: java.lang.String))(_.end).optionallyWith(state.map(value => value.unwrap))(_.state).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(ec2InstanceFamily.map(value => value: java.lang.String))(_.ec2InstanceFamily).optionallyWith(savingsPlanType.map(value => value.unwrap))(_.savingsPlanType).optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption).optionallyWith(productTypes.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.productTypesWithStrings).optionallyWith(currency.map(value => value.unwrap))(_.currency).optionallyWith(commitment.map(value => value: java.lang.String))(_.commitment).optionallyWith(upfrontPaymentAmount.map(value => value: java.lang.String))(_.upfrontPaymentAmount).optionallyWith(recurringPaymentAmount.map(value => value: java.lang.String))(_.recurringPaymentAmount).optionallyWith(termDurationInSeconds.map(value => value: java.lang.Long))(_.termDurationInSeconds).optionallyWith(tags.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> (value: java.lang.String)
    }).asJava))(_.tags).build()
  }
  def asReadOnly: SavingsPlan.ReadOnly = SavingsPlan.wrap(buildAwsValue())
}
object SavingsPlan {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.savingsplans.model.SavingsPlan] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: SavingsPlan = SavingsPlan(offeringIdValue.map(value => value), savingsPlanIdValue.map(value => value), savingsPlanArnValue.map(value => value), descriptionValue.map(value => value), startValue.map(value => value), endValue.map(value => value), stateValue.map(value => value), regionValue.map(value => value), ec2InstanceFamilyValue.map(value => value), savingsPlanTypeValue.map(value => value), paymentOptionValue.map(value => value), productTypesValue.map(value => value), currencyValue.map(value => value), commitmentValue.map(value => value), upfrontPaymentAmountValue.map(value => value), recurringPaymentAmountValue.map(value => value), termDurationInSecondsValue.map(value => value), tagsValue.map(value => value))
    def offeringIdValue: scala.Option[primitives.SavingsPlanOfferingId]
    def savingsPlanIdValue: scala.Option[primitives.SavingsPlanId]
    def savingsPlanArnValue: scala.Option[primitives.SavingsPlanArn]
    def descriptionValue: scala.Option[String]
    def startValue: scala.Option[String]
    def endValue: scala.Option[String]
    def stateValue: scala.Option[SavingsPlanState]
    def regionValue: scala.Option[primitives.Region]
    def ec2InstanceFamilyValue: scala.Option[primitives.EC2InstanceFamily]
    def savingsPlanTypeValue: scala.Option[SavingsPlanType]
    def paymentOptionValue: scala.Option[SavingsPlanPaymentOption]
    def productTypesValue: scala.Option[List[SavingsPlanProductType]]
    def currencyValue: scala.Option[CurrencyCode]
    def commitmentValue: scala.Option[primitives.Amount]
    def upfrontPaymentAmountValue: scala.Option[primitives.Amount]
    def recurringPaymentAmountValue: scala.Option[primitives.Amount]
    def termDurationInSecondsValue: scala.Option[primitives.TermDurationInSeconds]
    def tagsValue: scala.Option[Map[primitives.TagKey, primitives.TagValue]]
    def offeringId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SavingsPlanOfferingId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("offeringId", offeringIdValue)
    def savingsPlanId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SavingsPlanId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savingsPlanId", savingsPlanIdValue)
    def savingsPlanArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SavingsPlanArn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savingsPlanArn", savingsPlanArnValue)
    def description: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("description", descriptionValue)
    def start: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("start", startValue)
    def end: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("end", endValue)
    def state: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlanState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("state", stateValue)
    def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Region] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
    def ec2InstanceFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.EC2InstanceFamily] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ec2InstanceFamily", ec2InstanceFamilyValue)
    def savingsPlanType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlanType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savingsPlanType", savingsPlanTypeValue)
    def paymentOption: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlanPaymentOption] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("paymentOption", paymentOptionValue)
    def productTypes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SavingsPlanProductType]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("productTypes", productTypesValue)
    def currency: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CurrencyCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currency", currencyValue)
    def commitment: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Amount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("commitment", commitmentValue)
    def upfrontPaymentAmount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Amount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("upfrontPaymentAmount", upfrontPaymentAmountValue)
    def recurringPaymentAmount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Amount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("recurringPaymentAmount", recurringPaymentAmountValue)
    def termDurationInSeconds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TermDurationInSeconds] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("termDurationInSeconds", termDurationInSecondsValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[primitives.TagKey, primitives.TagValue]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlan) extends SavingsPlan.ReadOnly {
    override def offeringIdValue: scala.Option[primitives.SavingsPlanOfferingId] = scala.Option(impl.offeringId()).map(value => value: primitives.SavingsPlanOfferingId)
    override def savingsPlanIdValue: scala.Option[primitives.SavingsPlanId] = scala.Option(impl.savingsPlanId()).map(value => value: primitives.SavingsPlanId)
    override def savingsPlanArnValue: scala.Option[primitives.SavingsPlanArn] = scala.Option(impl.savingsPlanArn()).map(value => value: primitives.SavingsPlanArn)
    override def descriptionValue: scala.Option[String] = scala.Option(impl.description()).map(value => value: String)
    override def startValue: scala.Option[String] = scala.Option(impl.start()).map(value => value: String)
    override def endValue: scala.Option[String] = scala.Option(impl.end()).map(value => value: String)
    override def stateValue: scala.Option[SavingsPlanState] = scala.Option(impl.state()).map(value => SavingsPlanState.wrap(value))
    override def regionValue: scala.Option[primitives.Region] = scala.Option(impl.region()).map(value => value: primitives.Region)
    override def ec2InstanceFamilyValue: scala.Option[primitives.EC2InstanceFamily] = scala.Option(impl.ec2InstanceFamily()).map(value => value: primitives.EC2InstanceFamily)
    override def savingsPlanTypeValue: scala.Option[SavingsPlanType] = scala.Option(impl.savingsPlanType()).map(value => SavingsPlanType.wrap(value))
    override def paymentOptionValue: scala.Option[SavingsPlanPaymentOption] = scala.Option(impl.paymentOption()).map(value => SavingsPlanPaymentOption.wrap(value))
    override def productTypesValue: scala.Option[List[SavingsPlanProductType]] = scala.Option(impl.productTypes()).map(value => value.asScala.map { item => 
      SavingsPlanProductType.wrap(item)
    }.toList)
    override def currencyValue: scala.Option[CurrencyCode] = scala.Option(impl.currency()).map(value => CurrencyCode.wrap(value))
    override def commitmentValue: scala.Option[primitives.Amount] = scala.Option(impl.commitment()).map(value => value: primitives.Amount)
    override def upfrontPaymentAmountValue: scala.Option[primitives.Amount] = scala.Option(impl.upfrontPaymentAmount()).map(value => value: primitives.Amount)
    override def recurringPaymentAmountValue: scala.Option[primitives.Amount] = scala.Option(impl.recurringPaymentAmount()).map(value => value: primitives.Amount)
    override def termDurationInSecondsValue: scala.Option[primitives.TermDurationInSeconds] = scala.Option(impl.termDurationInSeconds()).map(value => value: primitives.TermDurationInSeconds)
    override def tagsValue: scala.Option[Map[primitives.TagKey, primitives.TagValue]] = scala.Option(impl.tags()).map(value => value.asScala.map({
      case (key, value) =>
        (key: primitives.TagKey) -> (value: primitives.TagValue)
    }).toMap)
  }
  def wrap(impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlan): ReadOnly = new Wrapper(impl)
}