package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait SavingsPlanState { def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanState }
object SavingsPlanState {
  def wrap(value: software.amazon.awssdk.services.savingsplans.model.SavingsPlanState): SavingsPlanState = value match {
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.PAYMENT_PENDING =>
      val r = `payment-pending`
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.PAYMENT_FAILED =>
      val r = `payment-failed`
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.RETIRED =>
      val r = retired
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.QUEUED =>
      val r = queued
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.QUEUED_DELETED =>
      val r = `queued-deleted`
      r
  }
  case object unknownToSdkVersion extends SavingsPlanState { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanState = software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.UNKNOWN_TO_SDK_VERSION }
  case object `payment-pending` extends SavingsPlanState { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanState = software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.PAYMENT_PENDING }
  case object `payment-failed` extends SavingsPlanState { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanState = software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.PAYMENT_FAILED }
  case object active extends SavingsPlanState { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanState = software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.ACTIVE }
  case object retired extends SavingsPlanState { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanState = software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.RETIRED }
  case object queued extends SavingsPlanState { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanState = software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.QUEUED }
  case object `queued-deleted` extends SavingsPlanState { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanState = software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.QUEUED_DELETED }
}