package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait SavingsPlanRatePropertyKey { def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyKey }
object SavingsPlanRatePropertyKey {
  def wrap(value: software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyKey): SavingsPlanRatePropertyKey = value match {
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyKey.REGION =>
      val r = region
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyKey.INSTANCE_TYPE =>
      val r = instanceType
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyKey.INSTANCE_FAMILY =>
      val r = instanceFamily
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyKey.PRODUCT_DESCRIPTION =>
      val r = productDescription
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyKey.TENANCY =>
      val r = tenancy
      r
  }
  case object unknownToSdkVersion extends SavingsPlanRatePropertyKey { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyKey = software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyKey.UNKNOWN_TO_SDK_VERSION }
  case object region extends SavingsPlanRatePropertyKey { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyKey = software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyKey.REGION }
  case object instanceType extends SavingsPlanRatePropertyKey { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyKey = software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyKey.INSTANCE_TYPE }
  case object instanceFamily extends SavingsPlanRatePropertyKey { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyKey = software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyKey.INSTANCE_FAMILY }
  case object productDescription extends SavingsPlanRatePropertyKey { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyKey = software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyKey.PRODUCT_DESCRIPTION }
  case object tenancy extends SavingsPlanRatePropertyKey { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyKey = software.amazon.awssdk.services.savingsplans.model.SavingsPlanRatePropertyKey.TENANCY }
}