package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeSavingsPlanRatesResponse(savingsPlanId: scala.Option[primitives.SavingsPlanId] = None, searchResults: scala.Option[Iterable[SavingsPlanRate]] = None, nextToken: scala.Option[primitives.PaginationToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesResponse = {
    import DescribeSavingsPlanRatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesResponse.builder().optionallyWith(savingsPlanId.map(value => value: java.lang.String))(_.savingsPlanId).optionallyWith(searchResults.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.searchResults).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: DescribeSavingsPlanRatesResponse.ReadOnly = DescribeSavingsPlanRatesResponse.wrap(buildAwsValue())
}
object DescribeSavingsPlanRatesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeSavingsPlanRatesResponse = DescribeSavingsPlanRatesResponse(savingsPlanIdValue.map(value => value), searchResultsValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def savingsPlanIdValue: scala.Option[primitives.SavingsPlanId]
    def searchResultsValue: scala.Option[List[SavingsPlanRate.ReadOnly]]
    def nextTokenValue: scala.Option[primitives.PaginationToken]
    def savingsPlanId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SavingsPlanId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savingsPlanId", savingsPlanIdValue)
    def searchResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SavingsPlanRate.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("searchResults", searchResultsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PaginationToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesResponse) extends DescribeSavingsPlanRatesResponse.ReadOnly {
    override def savingsPlanIdValue: scala.Option[primitives.SavingsPlanId] = scala.Option(impl.savingsPlanId()).map(value => value: primitives.SavingsPlanId)
    override def searchResultsValue: scala.Option[List[SavingsPlanRate.ReadOnly]] = scala.Option(impl.searchResults()).map(value => value.asScala.map { item => 
      SavingsPlanRate.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.PaginationToken] = scala.Option(impl.nextToken()).map(value => value: primitives.PaginationToken)
  }
  def wrap(impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesResponse): ReadOnly = new Wrapper(impl)
}