package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateSavingsPlanRequest(savingsPlanOfferingId: primitives.SavingsPlanOfferingId, commitment: primitives.Amount, upfrontPaymentAmount: scala.Option[primitives.Amount] = None, purchaseTime: scala.Option[primitives.DateTime] = None, clientToken: scala.Option[primitives.ClientToken] = None, tags: scala.Option[Map[primitives.TagKey, primitives.TagValue]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest = {
    import CreateSavingsPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest.builder().savingsPlanOfferingId(savingsPlanOfferingId: java.lang.String).commitment(commitment: java.lang.String).optionallyWith(upfrontPaymentAmount.map(value => value: java.lang.String))(_.upfrontPaymentAmount).optionallyWith(purchaseTime.map(value => value: java.time.Instant))(_.purchaseTime).optionallyWith(clientToken.map(value => value: java.lang.String))(_.clientToken).optionallyWith(tags.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> (value: java.lang.String)
    }).asJava))(_.tags).build()
  }
  def asReadOnly: CreateSavingsPlanRequest.ReadOnly = CreateSavingsPlanRequest.wrap(buildAwsValue())
}
object CreateSavingsPlanRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateSavingsPlanRequest = CreateSavingsPlanRequest(savingsPlanOfferingIdValue, commitmentValue, upfrontPaymentAmountValue.map(value => value), purchaseTimeValue.map(value => value), clientTokenValue.map(value => value), tagsValue.map(value => value))
    def savingsPlanOfferingIdValue: primitives.SavingsPlanOfferingId
    def commitmentValue: primitives.Amount
    def upfrontPaymentAmountValue: scala.Option[primitives.Amount]
    def purchaseTimeValue: scala.Option[primitives.DateTime]
    def clientTokenValue: scala.Option[primitives.ClientToken]
    def tagsValue: scala.Option[Map[primitives.TagKey, primitives.TagValue]]
    def savingsPlanOfferingId: ZIO[Any, Nothing, primitives.SavingsPlanOfferingId] = ZIO.succeed(savingsPlanOfferingIdValue)
    def commitment: ZIO[Any, Nothing, primitives.Amount] = ZIO.succeed(commitmentValue)
    def upfrontPaymentAmount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Amount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("upfrontPaymentAmount", upfrontPaymentAmountValue)
    def purchaseTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("purchaseTime", purchaseTimeValue)
    def clientToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ClientToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("clientToken", clientTokenValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[primitives.TagKey, primitives.TagValue]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest) extends CreateSavingsPlanRequest.ReadOnly {
    override def savingsPlanOfferingIdValue: primitives.SavingsPlanOfferingId = impl.savingsPlanOfferingId(): primitives.SavingsPlanOfferingId
    override def commitmentValue: primitives.Amount = impl.commitment(): primitives.Amount
    override def upfrontPaymentAmountValue: scala.Option[primitives.Amount] = scala.Option(impl.upfrontPaymentAmount()).map(value => value: primitives.Amount)
    override def purchaseTimeValue: scala.Option[primitives.DateTime] = scala.Option(impl.purchaseTime()).map(value => value: primitives.DateTime)
    override def clientTokenValue: scala.Option[primitives.ClientToken] = scala.Option(impl.clientToken()).map(value => value: primitives.ClientToken)
    override def tagsValue: scala.Option[Map[primitives.TagKey, primitives.TagValue]] = scala.Option(impl.tags()).map(value => value.asScala.map({
      case (key, value) =>
        (key: primitives.TagKey) -> (value: primitives.TagValue)
    }).toMap)
  }
  def wrap(impl: software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest): ReadOnly = new Wrapper(impl)
}