package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class TagResourceRequest(resourceArn: primitives.SavingsPlanArn, tags: Map[primitives.TagKey, primitives.TagValue]) {
  def buildAwsValue(): software.amazon.awssdk.services.savingsplans.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.TagResourceRequest.builder().resourceArn(resourceArn: java.lang.String).tags(tags.map({
      case (key, value) =>
        (key: java.lang.String) -> (value: java.lang.String)
    }).asJava).build()
  }
  def asReadOnly: TagResourceRequest.ReadOnly = TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.savingsplans.model.TagResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: TagResourceRequest = TagResourceRequest(resourceArnValue, tagsValue)
    def resourceArnValue: primitives.SavingsPlanArn
    def tagsValue: Map[primitives.TagKey, primitives.TagValue]
    def resourceArn: ZIO[Any, Nothing, primitives.SavingsPlanArn] = ZIO.succeed(resourceArnValue)
    def tags: ZIO[Any, Nothing, Map[primitives.TagKey, primitives.TagValue]] = ZIO.succeed(tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.savingsplans.model.TagResourceRequest) extends TagResourceRequest.ReadOnly {
    override def resourceArnValue: primitives.SavingsPlanArn = impl.resourceArn(): primitives.SavingsPlanArn
    override def tagsValue: Map[primitives.TagKey, primitives.TagValue] = impl.tags().asScala.map({
      case (key, value) =>
        (key: primitives.TagKey) -> (value: primitives.TagValue)
    }).toMap
  }
  def wrap(impl: software.amazon.awssdk.services.savingsplans.model.TagResourceRequest): ReadOnly = new Wrapper(impl)
}