package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class SavingsPlanRate(rate: scala.Option[primitives.Amount] = None, currency: scala.Option[CurrencyCode] = None, unit: scala.Option[SavingsPlanRateUnit] = None, productType: scala.Option[SavingsPlanProductType] = None, serviceCode: scala.Option[SavingsPlanRateServiceCode] = None, usageType: scala.Option[primitives.SavingsPlanRateUsageType] = None, operation: scala.Option[primitives.SavingsPlanRateOperation] = None, properties: scala.Option[Iterable[SavingsPlanRateProperty]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.savingsplans.model.SavingsPlanRate = {
    import SavingsPlanRate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanRate.builder().optionallyWith(rate.map(value => value: java.lang.String))(_.rate).optionallyWith(currency.map(value => value.unwrap))(_.currency).optionallyWith(unit.map(value => value.unwrap))(_.unit).optionallyWith(productType.map(value => value.unwrap))(_.productType).optionallyWith(serviceCode.map(value => value.unwrap))(_.serviceCode).optionallyWith(usageType.map(value => value: java.lang.String))(_.usageType).optionallyWith(operation.map(value => value: java.lang.String))(_.operation).optionallyWith(properties.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.properties).build()
  }
  def asReadOnly: SavingsPlanRate.ReadOnly = SavingsPlanRate.wrap(buildAwsValue())
}
object SavingsPlanRate {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.savingsplans.model.SavingsPlanRate] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: SavingsPlanRate = SavingsPlanRate(rateValue.map(value => value), currencyValue.map(value => value), unitValue.map(value => value), productTypeValue.map(value => value), serviceCodeValue.map(value => value), usageTypeValue.map(value => value), operationValue.map(value => value), propertiesValue.map(value => value.map { item => 
      item.editable
    }))
    def rateValue: scala.Option[primitives.Amount]
    def currencyValue: scala.Option[CurrencyCode]
    def unitValue: scala.Option[SavingsPlanRateUnit]
    def productTypeValue: scala.Option[SavingsPlanProductType]
    def serviceCodeValue: scala.Option[SavingsPlanRateServiceCode]
    def usageTypeValue: scala.Option[primitives.SavingsPlanRateUsageType]
    def operationValue: scala.Option[primitives.SavingsPlanRateOperation]
    def propertiesValue: scala.Option[List[SavingsPlanRateProperty.ReadOnly]]
    def rate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Amount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("rate", rateValue)
    def currency: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CurrencyCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currency", currencyValue)
    def unit: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlanRateUnit] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("unit", unitValue)
    def productType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlanProductType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("productType", productTypeValue)
    def serviceCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlanRateServiceCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("serviceCode", serviceCodeValue)
    def usageType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SavingsPlanRateUsageType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("usageType", usageTypeValue)
    def operation: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SavingsPlanRateOperation] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("operation", operationValue)
    def properties: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SavingsPlanRateProperty.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("properties", propertiesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanRate) extends SavingsPlanRate.ReadOnly {
    override def rateValue: scala.Option[primitives.Amount] = scala.Option(impl.rate()).map(value => value: primitives.Amount)
    override def currencyValue: scala.Option[CurrencyCode] = scala.Option(impl.currency()).map(value => CurrencyCode.wrap(value))
    override def unitValue: scala.Option[SavingsPlanRateUnit] = scala.Option(impl.unit()).map(value => SavingsPlanRateUnit.wrap(value))
    override def productTypeValue: scala.Option[SavingsPlanProductType] = scala.Option(impl.productType()).map(value => SavingsPlanProductType.wrap(value))
    override def serviceCodeValue: scala.Option[SavingsPlanRateServiceCode] = scala.Option(impl.serviceCode()).map(value => SavingsPlanRateServiceCode.wrap(value))
    override def usageTypeValue: scala.Option[primitives.SavingsPlanRateUsageType] = scala.Option(impl.usageType()).map(value => value: primitives.SavingsPlanRateUsageType)
    override def operationValue: scala.Option[primitives.SavingsPlanRateOperation] = scala.Option(impl.operation()).map(value => value: primitives.SavingsPlanRateOperation)
    override def propertiesValue: scala.Option[List[SavingsPlanRateProperty.ReadOnly]] = scala.Option(impl.properties()).map(value => value.asScala.map { item => 
      SavingsPlanRateProperty.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanRate): ReadOnly = new Wrapper(impl)
}