package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListTagsForResourceResponse(tags: scala.Option[Map[primitives.TagKey, primitives.TagValue]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceResponse.builder().optionallyWith(tags.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> (value: java.lang.String)
    }).asJava))(_.tags).build()
  }
  def asReadOnly: ListTagsForResourceResponse.ReadOnly = ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListTagsForResourceResponse = ListTagsForResourceResponse(tagsValue.map(value => value))
    def tagsValue: scala.Option[Map[primitives.TagKey, primitives.TagValue]]
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[primitives.TagKey, primitives.TagValue]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceResponse) extends ListTagsForResourceResponse.ReadOnly {
    override def tagsValue: scala.Option[Map[primitives.TagKey, primitives.TagValue]] = scala.Option(impl.tags()).map(value => value.asScala.map({
      case (key, value) =>
        (key: primitives.TagKey) -> (value: primitives.TagValue)
    }).toMap)
  }
  def wrap(impl: software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceResponse): ReadOnly = new Wrapper(impl)
}