package io.github.vigoo.zioaws.savingsplans
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
package object model {
  object primitives {
    type Amount = String
    type ClientToken = String
    type DateTime = Instant
    type EC2InstanceFamily = String
    type JsonSafeFilterValueString = String
    type MaxResults = Int
    type PageSize = Int
    type PaginationToken = String
    type Region = String
    type SavingsPlanArn = String
    type SavingsPlanDescription = String
    type SavingsPlanId = String
    type SavingsPlanOfferingId = String
    type SavingsPlanOperation = String
    type SavingsPlanRateOperation = String
    type SavingsPlanRatePricePerUnit = String
    type SavingsPlanRateUsageType = String
    type SavingsPlanServiceCode = String
    type SavingsPlanUsageType = String
    type SavingsPlansDuration = Long
    type TagKey = String
    type TagValue = String
    type TermDurationInSeconds = Long
    type UUID = String
  }
  type CurrencyList = List[CurrencyCode]
  type DurationsList = List[primitives.SavingsPlansDuration]
  type FilterValuesList = List[primitives.JsonSafeFilterValueString]
  type ListOfStrings = List[String]
  type SavingsPlanArnList = List[primitives.SavingsPlanArn]
  type SavingsPlanDescriptionsList = List[primitives.SavingsPlanDescription]
  type SavingsPlanFilterList = List[SavingsPlanFilter]
  type SavingsPlanIdList = List[primitives.SavingsPlanId]
  type SavingsPlanList = List[SavingsPlan]
  type SavingsPlanOfferingFiltersList = List[SavingsPlanOfferingFilterElement]
  type SavingsPlanOfferingPropertyList = List[SavingsPlanOfferingProperty]
  type SavingsPlanOfferingRateFiltersList = List[SavingsPlanOfferingRateFilterElement]
  type SavingsPlanOfferingRatePropertyList = List[SavingsPlanOfferingRateProperty]
  type SavingsPlanOfferingRatesList = List[SavingsPlanOfferingRate]
  type SavingsPlanOfferingsList = List[SavingsPlanOffering]
  type SavingsPlanOperationList = List[primitives.SavingsPlanOperation]
  type SavingsPlanPaymentOptionList = List[SavingsPlanPaymentOption]
  type SavingsPlanProductTypeList = List[SavingsPlanProductType]
  type SavingsPlanRateFilterList = List[SavingsPlanRateFilter]
  type SavingsPlanRateList = List[SavingsPlanRate]
  type SavingsPlanRateOperationList = List[primitives.SavingsPlanRateOperation]
  type SavingsPlanRatePropertyList = List[SavingsPlanRateProperty]
  type SavingsPlanRateServiceCodeList = List[SavingsPlanRateServiceCode]
  type SavingsPlanRateUsageTypeList = List[primitives.SavingsPlanRateUsageType]
  type SavingsPlanServiceCodeList = List[primitives.SavingsPlanServiceCode]
  type SavingsPlanStateList = List[SavingsPlanState]
  type SavingsPlanTypeList = List[SavingsPlanType]
  type SavingsPlanUsageTypeList = List[primitives.SavingsPlanUsageType]
  type TagKeyList = List[primitives.TagKey]
  type TagMap = Map[primitives.TagKey, primitives.TagValue]
  type UUIDs = List[primitives.UUID]
}