package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class SavingsPlanOffering(offeringId: scala.Option[primitives.UUID] = None, productTypes: scala.Option[Iterable[SavingsPlanProductType]] = None, planType: scala.Option[SavingsPlanType] = None, description: scala.Option[primitives.SavingsPlanDescription] = None, paymentOption: scala.Option[SavingsPlanPaymentOption] = None, durationSeconds: scala.Option[primitives.SavingsPlansDuration] = None, currency: scala.Option[CurrencyCode] = None, serviceCode: scala.Option[primitives.SavingsPlanServiceCode] = None, usageType: scala.Option[primitives.SavingsPlanUsageType] = None, operation: scala.Option[primitives.SavingsPlanOperation] = None, properties: scala.Option[Iterable[SavingsPlanOfferingProperty]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.savingsplans.model.SavingsPlanOffering = {
    import SavingsPlanOffering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOffering.builder().optionallyWith(offeringId.map(value => value: java.lang.String))(_.offeringId).optionallyWith(productTypes.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.productTypesWithStrings).optionallyWith(planType.map(value => value.unwrap))(_.planType).optionallyWith(description.map(value => value: java.lang.String))(_.description).optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption).optionallyWith(durationSeconds.map(value => value: java.lang.Long))(_.durationSeconds).optionallyWith(currency.map(value => value.unwrap))(_.currency).optionallyWith(serviceCode.map(value => value: java.lang.String))(_.serviceCode).optionallyWith(usageType.map(value => value: java.lang.String))(_.usageType).optionallyWith(operation.map(value => value: java.lang.String))(_.operation).optionallyWith(properties.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.properties).build()
  }
  def asReadOnly: SavingsPlanOffering.ReadOnly = SavingsPlanOffering.wrap(buildAwsValue())
}
object SavingsPlanOffering {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.savingsplans.model.SavingsPlanOffering] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: SavingsPlanOffering = SavingsPlanOffering(offeringIdValue.map(value => value), productTypesValue.map(value => value), planTypeValue.map(value => value), descriptionValue.map(value => value), paymentOptionValue.map(value => value), durationSecondsValue.map(value => value), currencyValue.map(value => value), serviceCodeValue.map(value => value), usageTypeValue.map(value => value), operationValue.map(value => value), propertiesValue.map(value => value.map { item => 
      item.editable
    }))
    def offeringIdValue: scala.Option[primitives.UUID]
    def productTypesValue: scala.Option[List[SavingsPlanProductType]]
    def planTypeValue: scala.Option[SavingsPlanType]
    def descriptionValue: scala.Option[primitives.SavingsPlanDescription]
    def paymentOptionValue: scala.Option[SavingsPlanPaymentOption]
    def durationSecondsValue: scala.Option[primitives.SavingsPlansDuration]
    def currencyValue: scala.Option[CurrencyCode]
    def serviceCodeValue: scala.Option[primitives.SavingsPlanServiceCode]
    def usageTypeValue: scala.Option[primitives.SavingsPlanUsageType]
    def operationValue: scala.Option[primitives.SavingsPlanOperation]
    def propertiesValue: scala.Option[List[SavingsPlanOfferingProperty.ReadOnly]]
    def offeringId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.UUID] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("offeringId", offeringIdValue)
    def productTypes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SavingsPlanProductType]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("productTypes", productTypesValue)
    def planType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlanType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("planType", planTypeValue)
    def description: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SavingsPlanDescription] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("description", descriptionValue)
    def paymentOption: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlanPaymentOption] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("paymentOption", paymentOptionValue)
    def durationSeconds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SavingsPlansDuration] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("durationSeconds", durationSecondsValue)
    def currency: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CurrencyCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currency", currencyValue)
    def serviceCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SavingsPlanServiceCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("serviceCode", serviceCodeValue)
    def usageType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SavingsPlanUsageType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("usageType", usageTypeValue)
    def operation: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SavingsPlanOperation] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("operation", operationValue)
    def properties: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SavingsPlanOfferingProperty.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("properties", propertiesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOffering) extends SavingsPlanOffering.ReadOnly {
    override def offeringIdValue: scala.Option[primitives.UUID] = scala.Option(impl.offeringId()).map(value => value: primitives.UUID)
    override def productTypesValue: scala.Option[List[SavingsPlanProductType]] = scala.Option(impl.productTypes()).map(value => value.asScala.map { item => 
      SavingsPlanProductType.wrap(item)
    }.toList)
    override def planTypeValue: scala.Option[SavingsPlanType] = scala.Option(impl.planType()).map(value => SavingsPlanType.wrap(value))
    override def descriptionValue: scala.Option[primitives.SavingsPlanDescription] = scala.Option(impl.description()).map(value => value: primitives.SavingsPlanDescription)
    override def paymentOptionValue: scala.Option[SavingsPlanPaymentOption] = scala.Option(impl.paymentOption()).map(value => SavingsPlanPaymentOption.wrap(value))
    override def durationSecondsValue: scala.Option[primitives.SavingsPlansDuration] = scala.Option(impl.durationSeconds()).map(value => value: primitives.SavingsPlansDuration)
    override def currencyValue: scala.Option[CurrencyCode] = scala.Option(impl.currency()).map(value => CurrencyCode.wrap(value))
    override def serviceCodeValue: scala.Option[primitives.SavingsPlanServiceCode] = scala.Option(impl.serviceCode()).map(value => value: primitives.SavingsPlanServiceCode)
    override def usageTypeValue: scala.Option[primitives.SavingsPlanUsageType] = scala.Option(impl.usageType()).map(value => value: primitives.SavingsPlanUsageType)
    override def operationValue: scala.Option[primitives.SavingsPlanOperation] = scala.Option(impl.operation()).map(value => value: primitives.SavingsPlanOperation)
    override def propertiesValue: scala.Option[List[SavingsPlanOfferingProperty.ReadOnly]] = scala.Option(impl.properties()).map(value => value.asScala.map { item => 
      SavingsPlanOfferingProperty.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOffering): ReadOnly = new Wrapper(impl)
}