package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeSavingsPlansOfferingsRequest(offeringIds: scala.Option[Iterable[primitives.UUID]] = None, paymentOptions: scala.Option[Iterable[SavingsPlanPaymentOption]] = None, productType: scala.Option[SavingsPlanProductType] = None, planTypes: scala.Option[Iterable[SavingsPlanType]] = None, durations: scala.Option[Iterable[primitives.SavingsPlansDuration]] = None, currencies: scala.Option[Iterable[CurrencyCode]] = None, descriptions: scala.Option[Iterable[primitives.SavingsPlanDescription]] = None, serviceCodes: scala.Option[Iterable[primitives.SavingsPlanServiceCode]] = None, usageTypes: scala.Option[Iterable[primitives.SavingsPlanUsageType]] = None, operations: scala.Option[Iterable[primitives.SavingsPlanOperation]] = None, filters: scala.Option[Iterable[SavingsPlanOfferingFilterElement]] = None, nextToken: scala.Option[primitives.PaginationToken] = None, maxResults: scala.Option[primitives.PageSize] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest = {
    import DescribeSavingsPlansOfferingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest.builder().optionallyWith(offeringIds.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.offeringIds).optionallyWith(paymentOptions.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.paymentOptionsWithStrings).optionallyWith(productType.map(value => value.unwrap))(_.productType).optionallyWith(planTypes.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.planTypesWithStrings).optionallyWith(durations.map(value => value.map { item => 
      item: java.lang.Long
    }.asJavaCollection))(_.durations).optionallyWith(currencies.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.currenciesWithStrings).optionallyWith(descriptions.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.descriptions).optionallyWith(serviceCodes.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.serviceCodes).optionallyWith(usageTypes.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.usageTypes).optionallyWith(operations.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.operations).optionallyWith(filters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.filters).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).build()
  }
  def asReadOnly: DescribeSavingsPlansOfferingsRequest.ReadOnly = DescribeSavingsPlansOfferingsRequest.wrap(buildAwsValue())
}
object DescribeSavingsPlansOfferingsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeSavingsPlansOfferingsRequest = DescribeSavingsPlansOfferingsRequest(offeringIdsValue.map(value => value), paymentOptionsValue.map(value => value), productTypeValue.map(value => value), planTypesValue.map(value => value), durationsValue.map(value => value), currenciesValue.map(value => value), descriptionsValue.map(value => value), serviceCodesValue.map(value => value), usageTypesValue.map(value => value), operationsValue.map(value => value), filtersValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value), maxResultsValue.map(value => value))
    def offeringIdsValue: scala.Option[List[primitives.UUID]]
    def paymentOptionsValue: scala.Option[List[SavingsPlanPaymentOption]]
    def productTypeValue: scala.Option[SavingsPlanProductType]
    def planTypesValue: scala.Option[List[SavingsPlanType]]
    def durationsValue: scala.Option[List[primitives.SavingsPlansDuration]]
    def currenciesValue: scala.Option[List[CurrencyCode]]
    def descriptionsValue: scala.Option[List[primitives.SavingsPlanDescription]]
    def serviceCodesValue: scala.Option[List[primitives.SavingsPlanServiceCode]]
    def usageTypesValue: scala.Option[List[primitives.SavingsPlanUsageType]]
    def operationsValue: scala.Option[List[primitives.SavingsPlanOperation]]
    def filtersValue: scala.Option[List[SavingsPlanOfferingFilterElement.ReadOnly]]
    def nextTokenValue: scala.Option[primitives.PaginationToken]
    def maxResultsValue: scala.Option[primitives.PageSize]
    def offeringIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.UUID]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("offeringIds", offeringIdsValue)
    def paymentOptions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SavingsPlanPaymentOption]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("paymentOptions", paymentOptionsValue)
    def productType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlanProductType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("productType", productTypeValue)
    def planTypes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SavingsPlanType]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("planTypes", planTypesValue)
    def durations: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.SavingsPlansDuration]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("durations", durationsValue)
    def currencies: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[CurrencyCode]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currencies", currenciesValue)
    def descriptions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.SavingsPlanDescription]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("descriptions", descriptionsValue)
    def serviceCodes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.SavingsPlanServiceCode]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("serviceCodes", serviceCodesValue)
    def usageTypes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.SavingsPlanUsageType]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("usageTypes", usageTypesValue)
    def operations: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.SavingsPlanOperation]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("operations", operationsValue)
    def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SavingsPlanOfferingFilterElement.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PaginationToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PageSize] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest) extends DescribeSavingsPlansOfferingsRequest.ReadOnly {
    override def offeringIdsValue: scala.Option[List[primitives.UUID]] = scala.Option(impl.offeringIds()).map(value => value.asScala.map { item => 
      item: primitives.UUID
    }.toList)
    override def paymentOptionsValue: scala.Option[List[SavingsPlanPaymentOption]] = scala.Option(impl.paymentOptions()).map(value => value.asScala.map { item => 
      SavingsPlanPaymentOption.wrap(item)
    }.toList)
    override def productTypeValue: scala.Option[SavingsPlanProductType] = scala.Option(impl.productType()).map(value => SavingsPlanProductType.wrap(value))
    override def planTypesValue: scala.Option[List[SavingsPlanType]] = scala.Option(impl.planTypes()).map(value => value.asScala.map { item => 
      SavingsPlanType.wrap(item)
    }.toList)
    override def durationsValue: scala.Option[List[primitives.SavingsPlansDuration]] = scala.Option(impl.durations()).map(value => value.asScala.map { item => 
      item: primitives.SavingsPlansDuration
    }.toList)
    override def currenciesValue: scala.Option[List[CurrencyCode]] = scala.Option(impl.currencies()).map(value => value.asScala.map { item => 
      CurrencyCode.wrap(item)
    }.toList)
    override def descriptionsValue: scala.Option[List[primitives.SavingsPlanDescription]] = scala.Option(impl.descriptions()).map(value => value.asScala.map { item => 
      item: primitives.SavingsPlanDescription
    }.toList)
    override def serviceCodesValue: scala.Option[List[primitives.SavingsPlanServiceCode]] = scala.Option(impl.serviceCodes()).map(value => value.asScala.map { item => 
      item: primitives.SavingsPlanServiceCode
    }.toList)
    override def usageTypesValue: scala.Option[List[primitives.SavingsPlanUsageType]] = scala.Option(impl.usageTypes()).map(value => value.asScala.map { item => 
      item: primitives.SavingsPlanUsageType
    }.toList)
    override def operationsValue: scala.Option[List[primitives.SavingsPlanOperation]] = scala.Option(impl.operations()).map(value => value.asScala.map { item => 
      item: primitives.SavingsPlanOperation
    }.toList)
    override def filtersValue: scala.Option[List[SavingsPlanOfferingFilterElement.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
      SavingsPlanOfferingFilterElement.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.PaginationToken] = scala.Option(impl.nextToken()).map(value => value: primitives.PaginationToken)
    override def maxResultsValue: scala.Option[primitives.PageSize] = scala.Option(impl.maxResults()).map(value => value: primitives.PageSize)
  }
  def wrap(impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest): ReadOnly = new Wrapper(impl)
}