package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.core.*
import io.github.vigoo.zioaws.core.aspects.*
import io.github.vigoo.zioaws.core.config.AwsConfig
import io.github.vigoo.zioaws.core.httpclient.ServiceHttpCapabilities
import software.amazon.awssdk.core.client.config.{ ClientAsyncConfiguration, SdkAdvancedAsyncClientOption }
import software.amazon.awssdk.services.savingsplans.{ SavingsplansAsyncClient, SavingsplansAsyncClientBuilder }
import zio.{ Chunk, Has, IO, URLayer, ZIO, ZLayer, ZManaged }
import zio.stream.ZStream
import org.reactivestreams.Publisher
import scala.jdk.CollectionConverters.*
package object savingsplans {
  type Savingsplans = Has[Savingsplans.Service]
  object Savingsplans {
    trait Service extends AspectSupport[Service] {
      val api: SavingsplansAsyncClient
      def deleteQueuedSavingsPlan(request: model.DeleteQueuedSavingsPlanRequest): IO[AwsError, model.DeleteQueuedSavingsPlanResponse.ReadOnly]
      def describeSavingsPlansOfferings(request: model.DescribeSavingsPlansOfferingsRequest): IO[AwsError, model.DescribeSavingsPlansOfferingsResponse.ReadOnly]
      def describeSavingsPlans(request: model.DescribeSavingsPlansRequest): IO[AwsError, model.DescribeSavingsPlansResponse.ReadOnly]
      def createSavingsPlan(request: model.CreateSavingsPlanRequest): IO[AwsError, model.CreateSavingsPlanResponse.ReadOnly]
      def untagResource(request: model.UntagResourceRequest): IO[AwsError, model.UntagResourceResponse.ReadOnly]
      def describeSavingsPlansOfferingRates(request: model.DescribeSavingsPlansOfferingRatesRequest): IO[AwsError, model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly]
      def listTagsForResource(request: model.ListTagsForResourceRequest): IO[AwsError, model.ListTagsForResourceResponse.ReadOnly]
      def describeSavingsPlanRates(request: model.DescribeSavingsPlanRatesRequest): IO[AwsError, model.DescribeSavingsPlanRatesResponse.ReadOnly]
      def tagResource(request: model.TagResourceRequest): IO[AwsError, model.TagResourceResponse.ReadOnly]
    }
    object SavingsplansMock extends zio.test.mock.Mock[Savingsplans] {
      object DeleteQueuedSavingsPlan extends Effect[model.DeleteQueuedSavingsPlanRequest, AwsError, model.DeleteQueuedSavingsPlanResponse.ReadOnly]
      object DescribeSavingsPlansOfferings extends Effect[model.DescribeSavingsPlansOfferingsRequest, AwsError, model.DescribeSavingsPlansOfferingsResponse.ReadOnly]
      object DescribeSavingsPlans extends Effect[model.DescribeSavingsPlansRequest, AwsError, model.DescribeSavingsPlansResponse.ReadOnly]
      object CreateSavingsPlan extends Effect[model.CreateSavingsPlanRequest, AwsError, model.CreateSavingsPlanResponse.ReadOnly]
      object UntagResource extends Effect[model.UntagResourceRequest, AwsError, model.UntagResourceResponse.ReadOnly]
      object DescribeSavingsPlansOfferingRates extends Effect[model.DescribeSavingsPlansOfferingRatesRequest, AwsError, model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly]
      object ListTagsForResource extends Effect[model.ListTagsForResourceRequest, AwsError, model.ListTagsForResourceResponse.ReadOnly]
      object DescribeSavingsPlanRates extends Effect[model.DescribeSavingsPlanRatesRequest, AwsError, model.DescribeSavingsPlanRatesResponse.ReadOnly]
      object TagResource extends Effect[model.TagResourceRequest, AwsError, model.TagResourceResponse.ReadOnly]
      val compose: URLayer[Has[zio.test.mock.Proxy], Savingsplans] = ZLayer.fromServiceM {
        proxy => withRuntime.map {
          rts => new Savingsplans.Service {
            val api: SavingsplansAsyncClient = null
            def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): Savingsplans.Service = this
            def deleteQueuedSavingsPlan(request: model.DeleteQueuedSavingsPlanRequest): IO[AwsError, model.DeleteQueuedSavingsPlanResponse.ReadOnly] = proxy(DeleteQueuedSavingsPlan, request)
            def describeSavingsPlansOfferings(request: model.DescribeSavingsPlansOfferingsRequest): IO[AwsError, model.DescribeSavingsPlansOfferingsResponse.ReadOnly] = proxy(DescribeSavingsPlansOfferings, request)
            def describeSavingsPlans(request: model.DescribeSavingsPlansRequest): IO[AwsError, model.DescribeSavingsPlansResponse.ReadOnly] = proxy(DescribeSavingsPlans, request)
            def createSavingsPlan(request: model.CreateSavingsPlanRequest): IO[AwsError, model.CreateSavingsPlanResponse.ReadOnly] = proxy(CreateSavingsPlan, request)
            def untagResource(request: model.UntagResourceRequest): IO[AwsError, model.UntagResourceResponse.ReadOnly] = proxy(UntagResource, request)
            def describeSavingsPlansOfferingRates(request: model.DescribeSavingsPlansOfferingRatesRequest): IO[AwsError, model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly] = proxy(DescribeSavingsPlansOfferingRates, request)
            def listTagsForResource(request: model.ListTagsForResourceRequest): IO[AwsError, model.ListTagsForResourceResponse.ReadOnly] = proxy(ListTagsForResource, request)
            def describeSavingsPlanRates(request: model.DescribeSavingsPlanRatesRequest): IO[AwsError, model.DescribeSavingsPlanRatesResponse.ReadOnly] = proxy(DescribeSavingsPlanRates, request)
            def tagResource(request: model.TagResourceRequest): IO[AwsError, model.TagResourceResponse.ReadOnly] = proxy(TagResource, request)
          }
        }
      }
    }
  }
  val live: ZLayer[AwsConfig, Throwable, Savingsplans] = customized(identity)
  def customized(customization: SavingsplansAsyncClientBuilder => SavingsplansAsyncClientBuilder): ZLayer[AwsConfig, Throwable, Savingsplans] = managed(customization).toLayer
  def managed(customization: SavingsplansAsyncClientBuilder => SavingsplansAsyncClientBuilder): ZManaged[AwsConfig, Throwable, Savingsplans.Service] = for (awsConfig <- ZManaged.service[AwsConfig.Service]; executor <- ZIO.executor.toManaged_; builder = SavingsplansAsyncClient.builder().asyncConfiguration(ClientAsyncConfiguration.builder().advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, executor.asJava).build()); b0 <- awsConfig.configure[SavingsplansAsyncClient, SavingsplansAsyncClientBuilder](builder).toManaged_; b1 <- awsConfig.configureHttpClient[SavingsplansAsyncClient, SavingsplansAsyncClientBuilder](b0, ServiceHttpCapabilities(supportsHttp2 = false)).toManaged_; client <- ZIO(customization(b1).build()).toManaged_) yield new SavingsplansImpl(client, AwsCallAspect.identity, ().asInstanceOf[Any])
  private class SavingsplansImpl[R](override val api: SavingsplansAsyncClient, override val aspect: AwsCallAspect[R], r: R) extends Savingsplans.Service with AwsServiceBase[R, SavingsplansImpl] {
    override val serviceName: String = "Savingsplans"
    override def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): SavingsplansImpl[R1] = new SavingsplansImpl(api, newAspect, r)
    def deleteQueuedSavingsPlan(request: model.DeleteQueuedSavingsPlanRequest): IO[AwsError, model.DeleteQueuedSavingsPlanResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.savingsplans.model.DeleteQueuedSavingsPlanRequest, software.amazon.awssdk.services.savingsplans.model.DeleteQueuedSavingsPlanResponse]("deleteQueuedSavingsPlan", api.deleteQueuedSavingsPlan)(request.buildAwsValue()).map(model.DeleteQueuedSavingsPlanResponse.wrap).provide(r)
    def describeSavingsPlansOfferings(request: model.DescribeSavingsPlansOfferingsRequest): IO[AwsError, model.DescribeSavingsPlansOfferingsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest, software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsResponse]("describeSavingsPlansOfferings", api.describeSavingsPlansOfferings)(request.buildAwsValue()).map(model.DescribeSavingsPlansOfferingsResponse.wrap).provide(r)
    def describeSavingsPlans(request: model.DescribeSavingsPlansRequest): IO[AwsError, model.DescribeSavingsPlansResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest, software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansResponse]("describeSavingsPlans", api.describeSavingsPlans)(request.buildAwsValue()).map(model.DescribeSavingsPlansResponse.wrap).provide(r)
    def createSavingsPlan(request: model.CreateSavingsPlanRequest): IO[AwsError, model.CreateSavingsPlanResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest, software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanResponse]("createSavingsPlan", api.createSavingsPlan)(request.buildAwsValue()).map(model.CreateSavingsPlanResponse.wrap).provide(r)
    def untagResource(request: model.UntagResourceRequest): IO[AwsError, model.UntagResourceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest, software.amazon.awssdk.services.savingsplans.model.UntagResourceResponse]("untagResource", api.untagResource)(request.buildAwsValue()).map(model.UntagResourceResponse.wrap).provide(r)
    def describeSavingsPlansOfferingRates(request: model.DescribeSavingsPlansOfferingRatesRequest): IO[AwsError, model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest, software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse]("describeSavingsPlansOfferingRates", api.describeSavingsPlansOfferingRates)(request.buildAwsValue()).map(model.DescribeSavingsPlansOfferingRatesResponse.wrap).provide(r)
    def listTagsForResource(request: model.ListTagsForResourceRequest): IO[AwsError, model.ListTagsForResourceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceRequest, software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceResponse]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue()).map(model.ListTagsForResourceResponse.wrap).provide(r)
    def describeSavingsPlanRates(request: model.DescribeSavingsPlanRatesRequest): IO[AwsError, model.DescribeSavingsPlanRatesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest, software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesResponse]("describeSavingsPlanRates", api.describeSavingsPlanRates)(request.buildAwsValue()).map(model.DescribeSavingsPlanRatesResponse.wrap).provide(r)
    def tagResource(request: model.TagResourceRequest): IO[AwsError, model.TagResourceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.savingsplans.model.TagResourceRequest, software.amazon.awssdk.services.savingsplans.model.TagResourceResponse]("tagResource", api.tagResource)(request.buildAwsValue()).map(model.TagResourceResponse.wrap).provide(r)
  }
  def deleteQueuedSavingsPlan(request: model.DeleteQueuedSavingsPlanRequest): ZIO[Savingsplans, AwsError, model.DeleteQueuedSavingsPlanResponse.ReadOnly] = ZIO.accessM(_.get.deleteQueuedSavingsPlan(request))
  def describeSavingsPlansOfferings(request: model.DescribeSavingsPlansOfferingsRequest): ZIO[Savingsplans, AwsError, model.DescribeSavingsPlansOfferingsResponse.ReadOnly] = ZIO.accessM(_.get.describeSavingsPlansOfferings(request))
  def describeSavingsPlans(request: model.DescribeSavingsPlansRequest): ZIO[Savingsplans, AwsError, model.DescribeSavingsPlansResponse.ReadOnly] = ZIO.accessM(_.get.describeSavingsPlans(request))
  def createSavingsPlan(request: model.CreateSavingsPlanRequest): ZIO[Savingsplans, AwsError, model.CreateSavingsPlanResponse.ReadOnly] = ZIO.accessM(_.get.createSavingsPlan(request))
  def untagResource(request: model.UntagResourceRequest): ZIO[Savingsplans, AwsError, model.UntagResourceResponse.ReadOnly] = ZIO.accessM(_.get.untagResource(request))
  def describeSavingsPlansOfferingRates(request: model.DescribeSavingsPlansOfferingRatesRequest): ZIO[Savingsplans, AwsError, model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly] = ZIO.accessM(_.get.describeSavingsPlansOfferingRates(request))
  def listTagsForResource(request: model.ListTagsForResourceRequest): ZIO[Savingsplans, AwsError, model.ListTagsForResourceResponse.ReadOnly] = ZIO.accessM(_.get.listTagsForResource(request))
  def describeSavingsPlanRates(request: model.DescribeSavingsPlanRatesRequest): ZIO[Savingsplans, AwsError, model.DescribeSavingsPlanRatesResponse.ReadOnly] = ZIO.accessM(_.get.describeSavingsPlanRates(request))
  def tagResource(request: model.TagResourceRequest): ZIO[Savingsplans, AwsError, model.TagResourceResponse.ReadOnly] = ZIO.accessM(_.get.tagResource(request))
}