package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait SavingsPlanProductType { def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType }
object SavingsPlanProductType {
  def wrap(value: software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType): SavingsPlanProductType = value match {
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType.EC2 =>
      val r = EC2
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType.FARGATE =>
      val r = Fargate
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType.LAMBDA =>
      val r = Lambda
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType.SAGE_MAKER =>
      val r = SageMaker
      r
  }
  case object unknownToSdkVersion extends SavingsPlanProductType { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType = software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType.UNKNOWN_TO_SDK_VERSION }
  case object EC2 extends SavingsPlanProductType { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType = software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType.EC2 }
  case object Fargate extends SavingsPlanProductType { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType = software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType.FARGATE }
  case object Lambda extends SavingsPlanProductType { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType = software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType.LAMBDA }
  case object SageMaker extends SavingsPlanProductType { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType = software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType.SAGE_MAKER }
}