package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeSavingsPlanRatesRequest(savingsPlanId: primitives.SavingsPlanId, filters: scala.Option[Iterable[SavingsPlanRateFilter]] = None, nextToken: scala.Option[primitives.PaginationToken] = None, maxResults: scala.Option[primitives.MaxResults] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest = {
    import DescribeSavingsPlanRatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest.builder().savingsPlanId(savingsPlanId: java.lang.String).optionallyWith(filters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.filters).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).build()
  }
  def asReadOnly: DescribeSavingsPlanRatesRequest.ReadOnly = DescribeSavingsPlanRatesRequest.wrap(buildAwsValue())
}
object DescribeSavingsPlanRatesRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeSavingsPlanRatesRequest = DescribeSavingsPlanRatesRequest(savingsPlanIdValue, filtersValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value), maxResultsValue.map(value => value))
    def savingsPlanIdValue: primitives.SavingsPlanId
    def filtersValue: scala.Option[List[SavingsPlanRateFilter.ReadOnly]]
    def nextTokenValue: scala.Option[primitives.PaginationToken]
    def maxResultsValue: scala.Option[primitives.MaxResults]
    def savingsPlanId: ZIO[Any, Nothing, primitives.SavingsPlanId] = ZIO.succeed(savingsPlanIdValue)
    def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SavingsPlanRateFilter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PaginationToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResults] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest) extends DescribeSavingsPlanRatesRequest.ReadOnly {
    override def savingsPlanIdValue: primitives.SavingsPlanId = impl.savingsPlanId(): primitives.SavingsPlanId
    override def filtersValue: scala.Option[List[SavingsPlanRateFilter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
      SavingsPlanRateFilter.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.PaginationToken] = scala.Option(impl.nextToken()).map(value => value: primitives.PaginationToken)
    override def maxResultsValue: scala.Option[primitives.MaxResults] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResults)
  }
  def wrap(impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest): ReadOnly = new Wrapper(impl)
}