package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UntagResourceRequest(resourceArn: primitives.SavingsPlanArn, tagKeys: Iterable[primitives.TagKey]) {
  def buildAwsValue(): software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest.builder().resourceArn(resourceArn: java.lang.String).tagKeys(tagKeys.map { item => 
      item: java.lang.String
    }.asJavaCollection).build()
  }
  def asReadOnly: UntagResourceRequest.ReadOnly = UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UntagResourceRequest = UntagResourceRequest(resourceArnValue, tagKeysValue)
    def resourceArnValue: primitives.SavingsPlanArn
    def tagKeysValue: List[primitives.TagKey]
    def resourceArn: ZIO[Any, Nothing, primitives.SavingsPlanArn] = ZIO.succeed(resourceArnValue)
    def tagKeys: ZIO[Any, Nothing, List[primitives.TagKey]] = ZIO.succeed(tagKeysValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest) extends UntagResourceRequest.ReadOnly {
    override def resourceArnValue: primitives.SavingsPlanArn = impl.resourceArn(): primitives.SavingsPlanArn
    override def tagKeysValue: List[primitives.TagKey] = impl.tagKeys().asScala.map { item => 
      item: primitives.TagKey
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest): ReadOnly = new Wrapper(impl)
}