package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeSavingsPlansOfferingRatesRequest(savingsPlanOfferingIds: scala.Option[Iterable[primitives.UUID]] = None, savingsPlanPaymentOptions: scala.Option[Iterable[SavingsPlanPaymentOption]] = None, savingsPlanTypes: scala.Option[Iterable[SavingsPlanType]] = None, products: scala.Option[Iterable[SavingsPlanProductType]] = None, serviceCodes: scala.Option[Iterable[SavingsPlanRateServiceCode]] = None, usageTypes: scala.Option[Iterable[primitives.SavingsPlanRateUsageType]] = None, operations: scala.Option[Iterable[primitives.SavingsPlanRateOperation]] = None, filters: scala.Option[Iterable[SavingsPlanOfferingRateFilterElement]] = None, nextToken: scala.Option[primitives.PaginationToken] = None, maxResults: scala.Option[primitives.PageSize] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest = {
    import DescribeSavingsPlansOfferingRatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest.builder().optionallyWith(savingsPlanOfferingIds.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.savingsPlanOfferingIds).optionallyWith(savingsPlanPaymentOptions.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.savingsPlanPaymentOptionsWithStrings).optionallyWith(savingsPlanTypes.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.savingsPlanTypesWithStrings).optionallyWith(products.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.productsWithStrings).optionallyWith(serviceCodes.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.serviceCodesWithStrings).optionallyWith(usageTypes.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.usageTypes).optionallyWith(operations.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.operations).optionallyWith(filters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.filters).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).build()
  }
  def asReadOnly: DescribeSavingsPlansOfferingRatesRequest.ReadOnly = DescribeSavingsPlansOfferingRatesRequest.wrap(buildAwsValue())
}
object DescribeSavingsPlansOfferingRatesRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeSavingsPlansOfferingRatesRequest = DescribeSavingsPlansOfferingRatesRequest(savingsPlanOfferingIdsValue.map(value => value), savingsPlanPaymentOptionsValue.map(value => value), savingsPlanTypesValue.map(value => value), productsValue.map(value => value), serviceCodesValue.map(value => value), usageTypesValue.map(value => value), operationsValue.map(value => value), filtersValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value), maxResultsValue.map(value => value))
    def savingsPlanOfferingIdsValue: scala.Option[List[primitives.UUID]]
    def savingsPlanPaymentOptionsValue: scala.Option[List[SavingsPlanPaymentOption]]
    def savingsPlanTypesValue: scala.Option[List[SavingsPlanType]]
    def productsValue: scala.Option[List[SavingsPlanProductType]]
    def serviceCodesValue: scala.Option[List[SavingsPlanRateServiceCode]]
    def usageTypesValue: scala.Option[List[primitives.SavingsPlanRateUsageType]]
    def operationsValue: scala.Option[List[primitives.SavingsPlanRateOperation]]
    def filtersValue: scala.Option[List[SavingsPlanOfferingRateFilterElement.ReadOnly]]
    def nextTokenValue: scala.Option[primitives.PaginationToken]
    def maxResultsValue: scala.Option[primitives.PageSize]
    def savingsPlanOfferingIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.UUID]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savingsPlanOfferingIds", savingsPlanOfferingIdsValue)
    def savingsPlanPaymentOptions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SavingsPlanPaymentOption]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savingsPlanPaymentOptions", savingsPlanPaymentOptionsValue)
    def savingsPlanTypes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SavingsPlanType]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savingsPlanTypes", savingsPlanTypesValue)
    def products: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SavingsPlanProductType]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("products", productsValue)
    def serviceCodes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SavingsPlanRateServiceCode]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("serviceCodes", serviceCodesValue)
    def usageTypes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.SavingsPlanRateUsageType]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("usageTypes", usageTypesValue)
    def operations: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.SavingsPlanRateOperation]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("operations", operationsValue)
    def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SavingsPlanOfferingRateFilterElement.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PaginationToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PageSize] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest) extends DescribeSavingsPlansOfferingRatesRequest.ReadOnly {
    override def savingsPlanOfferingIdsValue: scala.Option[List[primitives.UUID]] = scala.Option(impl.savingsPlanOfferingIds()).map(value => value.asScala.map { item => 
      item: primitives.UUID
    }.toList)
    override def savingsPlanPaymentOptionsValue: scala.Option[List[SavingsPlanPaymentOption]] = scala.Option(impl.savingsPlanPaymentOptions()).map(value => value.asScala.map { item => 
      SavingsPlanPaymentOption.wrap(item)
    }.toList)
    override def savingsPlanTypesValue: scala.Option[List[SavingsPlanType]] = scala.Option(impl.savingsPlanTypes()).map(value => value.asScala.map { item => 
      SavingsPlanType.wrap(item)
    }.toList)
    override def productsValue: scala.Option[List[SavingsPlanProductType]] = scala.Option(impl.products()).map(value => value.asScala.map { item => 
      SavingsPlanProductType.wrap(item)
    }.toList)
    override def serviceCodesValue: scala.Option[List[SavingsPlanRateServiceCode]] = scala.Option(impl.serviceCodes()).map(value => value.asScala.map { item => 
      SavingsPlanRateServiceCode.wrap(item)
    }.toList)
    override def usageTypesValue: scala.Option[List[primitives.SavingsPlanRateUsageType]] = scala.Option(impl.usageTypes()).map(value => value.asScala.map { item => 
      item: primitives.SavingsPlanRateUsageType
    }.toList)
    override def operationsValue: scala.Option[List[primitives.SavingsPlanRateOperation]] = scala.Option(impl.operations()).map(value => value.asScala.map { item => 
      item: primitives.SavingsPlanRateOperation
    }.toList)
    override def filtersValue: scala.Option[List[SavingsPlanOfferingRateFilterElement.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
      SavingsPlanOfferingRateFilterElement.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.PaginationToken] = scala.Option(impl.nextToken()).map(value => value: primitives.PaginationToken)
    override def maxResultsValue: scala.Option[primitives.PageSize] = scala.Option(impl.maxResults()).map(value => value: primitives.PageSize)
  }
  def wrap(impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest): ReadOnly = new Wrapper(impl)
}