package io.github.vigoo.zioaws.savingsplans.model
import io.github.vigoo.zioaws.savingsplans.model.primitives.{TagValue, TagKey}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.ListTagsForResourceResponse.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.ListTagsForResourceResponse =
      io.github.vigoo.zioaws.savingsplans.model
        .ListTagsForResourceResponse(tagsValue.map(value => value))
    def tagsValue: Option[Map[TagKey, TagValue]]
    def tags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceResponse
  ) extends io.github.vigoo.zioaws.savingsplans.model.ListTagsForResourceResponse.ReadOnly {
    override def tagsValue: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: TagKey) -> (value: TagValue)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceResponse
  ): io.github.vigoo.zioaws.savingsplans.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
