package io.github.vigoo.zioaws.savingsplans.model
import java.lang.Integer
import io.github.vigoo.zioaws.savingsplans.model.primitives.{
  SavingsPlansDuration,
  SavingsPlanUsageType,
  PaginationToken,
  UUID,
  SavingsPlanOperation,
  SavingsPlanServiceCode,
  SavingsPlanDescription,
  PageSize
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSavingsPlansOfferingsRequest(
    offeringIds: Option[Iterable[UUID]] = None,
    paymentOptions: Option[Iterable[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
    ]] = None,
    productType: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType
    ] = None,
    planTypes: Option[
      Iterable[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType]
    ] = None,
    durations: Option[Iterable[SavingsPlansDuration]] = None,
    currencies: Option[
      Iterable[io.github.vigoo.zioaws.savingsplans.model.CurrencyCode]
    ] = None,
    descriptions: Option[Iterable[SavingsPlanDescription]] = None,
    serviceCodes: Option[Iterable[SavingsPlanServiceCode]] = None,
    usageTypes: Option[Iterable[SavingsPlanUsageType]] = None,
    operations: Option[Iterable[SavingsPlanOperation]] = None,
    filters: Option[Iterable[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingFilterElement
    ]] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[PageSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest = {
    import DescribeSavingsPlansOfferingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest
      .builder()
      .optionallyWith(
        offeringIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.offeringIds)
      .optionallyWith(
        paymentOptions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.paymentOptionsWithStrings)
      .optionallyWith(productType.map(value => value.unwrap))(_.productType)
      .optionallyWith(
        planTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.planTypesWithStrings)
      .optionallyWith(
        durations.map(value =>
          value.map { item =>
            item: java.lang.Long
          }.asJavaCollection
        )
      )(_.durations)
      .optionallyWith(
        currencies.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.currenciesWithStrings)
      .optionallyWith(
        descriptions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.descriptions)
      .optionallyWith(
        serviceCodes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.serviceCodes)
      .optionallyWith(
        usageTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.usageTypes)
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.operations)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsRequest.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsRequest
      .wrap(buildAwsValue())
}
object DescribeSavingsPlansOfferingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsRequest =
      io.github.vigoo.zioaws.savingsplans.model
        .DescribeSavingsPlansOfferingsRequest(
          offeringIdsValue.map(value => value),
          paymentOptionsValue.map(value => value),
          productTypeValue.map(value => value),
          planTypesValue.map(value => value),
          durationsValue.map(value => value),
          currenciesValue.map(value => value),
          descriptionsValue.map(value => value),
          serviceCodesValue.map(value => value),
          usageTypesValue.map(value => value),
          operationsValue.map(value => value),
          filtersValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value),
          maxResultsValue.map(value => value)
        )
    def offeringIdsValue: Option[List[UUID]]
    def paymentOptionsValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption]
    ]
    def productTypeValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType
    ]
    def planTypesValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType]
    ]
    def durationsValue: Option[List[SavingsPlansDuration]]
    def currenciesValue
        : Option[List[io.github.vigoo.zioaws.savingsplans.model.CurrencyCode]]
    def descriptionsValue: Option[List[SavingsPlanDescription]]
    def serviceCodesValue: Option[List[SavingsPlanServiceCode]]
    def usageTypesValue: Option[List[SavingsPlanUsageType]]
    def operationsValue: Option[List[SavingsPlanOperation]]
    def filtersValue: Option[List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingFilterElement.ReadOnly
    ]]
    def nextTokenValue: Option[PaginationToken]
    def maxResultsValue: Option[PageSize]
    def offeringIds: ZIO[Any, AwsError, List[UUID]] =
      AwsError.unwrapOptionField("offeringIds", offeringIdsValue)
    def paymentOptions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
    ]] = AwsError.unwrapOptionField("paymentOptions", paymentOptionsValue)
    def productType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType
    ] = AwsError.unwrapOptionField("productType", productTypeValue)
    def planTypes: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType
    ]] = AwsError.unwrapOptionField("planTypes", planTypesValue)
    def durations: ZIO[Any, AwsError, List[SavingsPlansDuration]] =
      AwsError.unwrapOptionField("durations", durationsValue)
    def currencies: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.savingsplans.model.CurrencyCode
    ]] = AwsError.unwrapOptionField("currencies", currenciesValue)
    def descriptions: ZIO[Any, AwsError, List[SavingsPlanDescription]] =
      AwsError.unwrapOptionField("descriptions", descriptionsValue)
    def serviceCodes: ZIO[Any, AwsError, List[SavingsPlanServiceCode]] =
      AwsError.unwrapOptionField("serviceCodes", serviceCodesValue)
    def usageTypes: ZIO[Any, AwsError, List[SavingsPlanUsageType]] =
      AwsError.unwrapOptionField("usageTypes", usageTypesValue)
    def operations: ZIO[Any, AwsError, List[SavingsPlanOperation]] =
      AwsError.unwrapOptionField("operations", operationsValue)
    def filters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingFilterElement.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filtersValue)
    def nextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest
  ) extends io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsRequest.ReadOnly {
    override def offeringIdsValue: Option[List[UUID]] = scala
      .Option(impl.offeringIds())
      .map(value =>
        value.asScala.map { item =>
          item: UUID
        }.toList
      )
    override def paymentOptionsValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption]
    ] = scala
      .Option(impl.paymentOptions())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption
            .wrap(item)
        }.toList
      )
    override def productTypeValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType
    ] = scala
      .Option(impl.productType())
      .map(value =>
        io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType
          .wrap(value)
      )
    override def planTypesValue: Option[
      List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType]
    ] = scala
      .Option(impl.planTypes())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType.wrap(item)
        }.toList
      )
    override def durationsValue: Option[List[SavingsPlansDuration]] = scala
      .Option(impl.durations())
      .map(value =>
        value.asScala.map { item =>
          item: SavingsPlansDuration
        }.toList
      )
    override def currenciesValue
        : Option[List[io.github.vigoo.zioaws.savingsplans.model.CurrencyCode]] =
      scala
        .Option(impl.currencies())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.savingsplans.model.CurrencyCode.wrap(item)
          }.toList
        )
    override def descriptionsValue: Option[List[SavingsPlanDescription]] = scala
      .Option(impl.descriptions())
      .map(value =>
        value.asScala.map { item =>
          item: SavingsPlanDescription
        }.toList
      )
    override def serviceCodesValue: Option[List[SavingsPlanServiceCode]] = scala
      .Option(impl.serviceCodes())
      .map(value =>
        value.asScala.map { item =>
          item: SavingsPlanServiceCode
        }.toList
      )
    override def usageTypesValue: Option[List[SavingsPlanUsageType]] = scala
      .Option(impl.usageTypes())
      .map(value =>
        value.asScala.map { item =>
          item: SavingsPlanUsageType
        }.toList
      )
    override def operationsValue: Option[List[SavingsPlanOperation]] = scala
      .Option(impl.operations())
      .map(value =>
        value.asScala.map { item =>
          item: SavingsPlanOperation
        }.toList
      )
    override def filtersValue: Option[List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingFilterElement.ReadOnly
    ]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingFilterElement
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[PaginationToken] =
      scala.Option(impl.nextToken()).map(value => value: PaginationToken)
    override def maxResultsValue: Option[PageSize] =
      scala.Option(impl.maxResults()).map(value => value: PageSize)
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest
  ): io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlansOfferingsRequest.ReadOnly =
    new Wrapper(impl)
}
