package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait SavingsPlanPaymentOption { def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption }
object SavingsPlanPaymentOption {
  def wrap(value: software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption): SavingsPlanPaymentOption = value match {
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption.ALL_UPFRONT =>
      val r = `All Upfront`
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption.PARTIAL_UPFRONT =>
      val r = `Partial Upfront`
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption.NO_UPFRONT =>
      val r = `No Upfront`
      r
  }
  case object unknownToSdkVersion extends SavingsPlanPaymentOption { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption = software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption.UNKNOWN_TO_SDK_VERSION }
  case object `All Upfront` extends SavingsPlanPaymentOption { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption = software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption.ALL_UPFRONT }
  case object `Partial Upfront` extends SavingsPlanPaymentOption { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption = software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption.PARTIAL_UPFRONT }
  case object `No Upfront` extends SavingsPlanPaymentOption { override def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption = software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption.NO_UPFRONT }
}