package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteQueuedSavingsPlanRequest(savingsPlanId: primitives.SavingsPlanId) {
  def buildAwsValue(): software.amazon.awssdk.services.savingsplans.model.DeleteQueuedSavingsPlanRequest = {
    import DeleteQueuedSavingsPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DeleteQueuedSavingsPlanRequest.builder().savingsPlanId(savingsPlanId: java.lang.String).build()
  }
  def asReadOnly: DeleteQueuedSavingsPlanRequest.ReadOnly = DeleteQueuedSavingsPlanRequest.wrap(buildAwsValue())
}
object DeleteQueuedSavingsPlanRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.savingsplans.model.DeleteQueuedSavingsPlanRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteQueuedSavingsPlanRequest = DeleteQueuedSavingsPlanRequest(savingsPlanIdValue)
    def savingsPlanIdValue: primitives.SavingsPlanId
    def savingsPlanId: ZIO[Any, Nothing, primitives.SavingsPlanId] = ZIO.succeed(savingsPlanIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.savingsplans.model.DeleteQueuedSavingsPlanRequest) extends DeleteQueuedSavingsPlanRequest.ReadOnly { override def savingsPlanIdValue: primitives.SavingsPlanId = impl.savingsPlanId(): primitives.SavingsPlanId }
  def wrap(impl: software.amazon.awssdk.services.savingsplans.model.DeleteQueuedSavingsPlanRequest): ReadOnly = new Wrapper(impl)
}