package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
sealed trait TargetType {
  def unwrap: software.amazon.awssdk.services.organizations.model.TargetType
}
object TargetType {
  def wrap(
      value: software.amazon.awssdk.services.organizations.model.TargetType
  ): io.github.vigoo.zioaws.organizations.model.TargetType = value match {
    case software.amazon.awssdk.services.organizations.model.TargetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.organizations.model.TargetType.ACCOUNT =>
      val r = ACCOUNT
      r
    case software.amazon.awssdk.services.organizations.model.TargetType.ORGANIZATIONAL_UNIT =>
      val r = ORGANIZATIONAL_UNIT
      r
    case software.amazon.awssdk.services.organizations.model.TargetType.ROOT =>
      val r = ROOT
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.organizations.model.TargetType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.TargetType =
      software.amazon.awssdk.services.organizations.model.TargetType.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCOUNT
      extends io.github.vigoo.zioaws.organizations.model.TargetType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.TargetType =
      software.amazon.awssdk.services.organizations.model.TargetType.ACCOUNT
  }
  case object ORGANIZATIONAL_UNIT
      extends io.github.vigoo.zioaws.organizations.model.TargetType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.TargetType =
      software.amazon.awssdk.services.organizations.model.TargetType.ORGANIZATIONAL_UNIT
  }
  case object ROOT
      extends io.github.vigoo.zioaws.organizations.model.TargetType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.TargetType =
      software.amazon.awssdk.services.organizations.model.TargetType.ROOT
  }
}
