package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  RootName,
  RootArn,
  RootId
}
import scala.jdk.CollectionConverters.*
final case class Root(
    id: Option[RootId] = None,
    arn: Option[RootArn] = None,
    name: Option[RootName] = None,
    policyTypes: Option[
      Iterable[io.github.vigoo.zioaws.organizations.model.PolicyTypeSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.Root = {
    import Root.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.Root
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        policyTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyTypes)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.organizations.model.Root.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.Root.wrap(buildAwsValue())
}
object Root {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.Root
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.organizations.model.Root =
      io.github.vigoo.zioaws.organizations.model.Root(
        idValue.map(value => value),
        arnValue.map(value => value),
        nameValue.map(value => value),
        policyTypesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def idValue: Option[RootId]
    def arnValue: Option[RootArn]
    def nameValue: Option[RootName]
    def policyTypesValue: Option[List[
      io.github.vigoo.zioaws.organizations.model.PolicyTypeSummary.ReadOnly
    ]]
    def id: ZIO[Any, AwsError, RootId] =
      AwsError.unwrapOptionField("id", idValue)
    def arn: ZIO[Any, AwsError, RootArn] =
      AwsError.unwrapOptionField("arn", arnValue)
    def name: ZIO[Any, AwsError, RootName] =
      AwsError.unwrapOptionField("name", nameValue)
    def policyTypes: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.PolicyTypeSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("policyTypes", policyTypesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.Root
  ) extends io.github.vigoo.zioaws.organizations.model.Root.ReadOnly {
    override def idValue: Option[RootId] =
      scala.Option(impl.id()).map(value => value: RootId)
    override def arnValue: Option[RootArn] =
      scala.Option(impl.arn()).map(value => value: RootArn)
    override def nameValue: Option[RootName] =
      scala.Option(impl.name()).map(value => value: RootName)
    override def policyTypesValue: Option[List[
      io.github.vigoo.zioaws.organizations.model.PolicyTypeSummary.ReadOnly
    ]] = scala
      .Option(impl.policyTypes())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.PolicyTypeSummary
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.Root
  ): io.github.vigoo.zioaws.organizations.model.Root.ReadOnly = new Wrapper(
    impl
  )
}
