package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.organizations.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class RemoveAccountFromOrganizationRequest(accountId: AccountId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationRequest = {
    import RemoveAccountFromOrganizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.RemoveAccountFromOrganizationRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.RemoveAccountFromOrganizationRequest
      .wrap(buildAwsValue())
}
object RemoveAccountFromOrganizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.RemoveAccountFromOrganizationRequest =
      io.github.vigoo.zioaws.organizations.model
        .RemoveAccountFromOrganizationRequest(accountIdValue)
    def accountIdValue: AccountId
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationRequest
  ) extends io.github.vigoo.zioaws.organizations.model.RemoveAccountFromOrganizationRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationRequest
  ): io.github.vigoo.zioaws.organizations.model.RemoveAccountFromOrganizationRequest.ReadOnly =
    new Wrapper(impl)
}
