package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  OrganizationArn,
  AccountId,
  OrganizationId,
  AccountArn,
  Email
}
import scala.jdk.CollectionConverters.*
final case class Organization(
    id: Option[OrganizationId] = None,
    arn: Option[OrganizationArn] = None,
    featureSet: Option[
      io.github.vigoo.zioaws.organizations.model.OrganizationFeatureSet
    ] = None,
    masterAccountArn: Option[AccountArn] = None,
    masterAccountId: Option[AccountId] = None,
    masterAccountEmail: Option[Email] = None,
    availablePolicyTypes: Option[
      Iterable[io.github.vigoo.zioaws.organizations.model.PolicyTypeSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.Organization = {
    import Organization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.Organization
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(featureSet.map(value => value.unwrap))(_.featureSet)
      .optionallyWith(masterAccountArn.map(value => value: java.lang.String))(
        _.masterAccountArn
      )
      .optionallyWith(masterAccountId.map(value => value: java.lang.String))(
        _.masterAccountId
      )
      .optionallyWith(masterAccountEmail.map(value => value: java.lang.String))(
        _.masterAccountEmail
      )
      .optionallyWith(
        availablePolicyTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availablePolicyTypes)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.Organization.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.Organization
      .wrap(buildAwsValue())
}
object Organization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.Organization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.organizations.model.Organization =
      io.github.vigoo.zioaws.organizations.model.Organization(
        idValue.map(value => value),
        arnValue.map(value => value),
        featureSetValue.map(value => value),
        masterAccountArnValue.map(value => value),
        masterAccountIdValue.map(value => value),
        masterAccountEmailValue.map(value => value),
        availablePolicyTypesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def idValue: Option[OrganizationId]
    def arnValue: Option[OrganizationArn]
    def featureSetValue: Option[
      io.github.vigoo.zioaws.organizations.model.OrganizationFeatureSet
    ]
    def masterAccountArnValue: Option[AccountArn]
    def masterAccountIdValue: Option[AccountId]
    def masterAccountEmailValue: Option[Email]
    def availablePolicyTypesValue: Option[List[
      io.github.vigoo.zioaws.organizations.model.PolicyTypeSummary.ReadOnly
    ]]
    def id: ZIO[Any, AwsError, OrganizationId] =
      AwsError.unwrapOptionField("id", idValue)
    def arn: ZIO[Any, AwsError, OrganizationArn] =
      AwsError.unwrapOptionField("arn", arnValue)
    def featureSet: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.OrganizationFeatureSet
    ] = AwsError.unwrapOptionField("featureSet", featureSetValue)
    def masterAccountArn: ZIO[Any, AwsError, AccountArn] =
      AwsError.unwrapOptionField("masterAccountArn", masterAccountArnValue)
    def masterAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("masterAccountId", masterAccountIdValue)
    def masterAccountEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("masterAccountEmail", masterAccountEmailValue)
    def availablePolicyTypes: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.PolicyTypeSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "availablePolicyTypes",
      availablePolicyTypesValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.Organization
  ) extends io.github.vigoo.zioaws.organizations.model.Organization.ReadOnly {
    override def idValue: Option[OrganizationId] =
      scala.Option(impl.id()).map(value => value: OrganizationId)
    override def arnValue: Option[OrganizationArn] =
      scala.Option(impl.arn()).map(value => value: OrganizationArn)
    override def featureSetValue: Option[
      io.github.vigoo.zioaws.organizations.model.OrganizationFeatureSet
    ] = scala
      .Option(impl.featureSet())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.OrganizationFeatureSet
          .wrap(value)
      )
    override def masterAccountArnValue: Option[AccountArn] =
      scala.Option(impl.masterAccountArn()).map(value => value: AccountArn)
    override def masterAccountIdValue: Option[AccountId] =
      scala.Option(impl.masterAccountId()).map(value => value: AccountId)
    override def masterAccountEmailValue: Option[Email] =
      scala.Option(impl.masterAccountEmail()).map(value => value: Email)
    override def availablePolicyTypesValue: Option[List[
      io.github.vigoo.zioaws.organizations.model.PolicyTypeSummary.ReadOnly
    ]] = scala
      .Option(impl.availablePolicyTypes())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.PolicyTypeSummary
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.Organization
  ): io.github.vigoo.zioaws.organizations.model.Organization.ReadOnly =
    new Wrapper(impl)
}
