package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.organizations.model.primitives.{
  ParentId,
  AccountId
}
import scala.jdk.CollectionConverters.*
final case class MoveAccountRequest(
    accountId: AccountId,
    sourceParentId: ParentId,
    destinationParentId: ParentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.MoveAccountRequest = {
    import MoveAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.MoveAccountRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .sourceParentId(sourceParentId: java.lang.String)
      .destinationParentId(destinationParentId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.MoveAccountRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.MoveAccountRequest
      .wrap(buildAwsValue())
}
object MoveAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.MoveAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.MoveAccountRequest =
      io.github.vigoo.zioaws.organizations.model.MoveAccountRequest(
        accountIdValue,
        sourceParentIdValue,
        destinationParentIdValue
      )
    def accountIdValue: AccountId
    def sourceParentIdValue: ParentId
    def destinationParentIdValue: ParentId
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def sourceParentId: ZIO[Any, Nothing, ParentId] =
      ZIO.succeed(sourceParentIdValue)
    def destinationParentId: ZIO[Any, Nothing, ParentId] =
      ZIO.succeed(destinationParentIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.MoveAccountRequest
  ) extends io.github.vigoo.zioaws.organizations.model.MoveAccountRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def sourceParentIdValue: ParentId = impl.sourceParentId(): ParentId
    override def destinationParentIdValue: ParentId =
      impl.destinationParentId(): ParentId
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.MoveAccountRequest
  ): io.github.vigoo.zioaws.organizations.model.MoveAccountRequest.ReadOnly =
    new Wrapper(impl)
}
