package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    tags: Option[Iterable[io.github.vigoo.zioaws.organizations.model.Tag]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListTagsForResourceResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListTagsForResourceResponse =
      io.github.vigoo.zioaws.organizations.model.ListTagsForResourceResponse(
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly]]
    def nextTokenValue: Option[NextToken]
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListTagsForResourceResponse
  ) extends io.github.vigoo.zioaws.organizations.model.ListTagsForResourceResponse.ReadOnly {
    override def tagsValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly]
    ] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.Tag.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListTagsForResourceResponse
  ): io.github.vigoo.zioaws.organizations.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
