package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListRootsResponse(
    roots: Option[Iterable[io.github.vigoo.zioaws.organizations.model.Root]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListRootsResponse = {
    import ListRootsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListRootsResponse
      .builder()
      .optionallyWith(
        roots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.roots)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListRootsResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListRootsResponse
      .wrap(buildAwsValue())
}
object ListRootsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListRootsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.organizations.model.ListRootsResponse =
      io.github.vigoo.zioaws.organizations.model.ListRootsResponse(
        rootsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def rootsValue
        : Option[List[io.github.vigoo.zioaws.organizations.model.Root.ReadOnly]]
    def nextTokenValue: Option[NextToken]
    def roots: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.Root.ReadOnly
    ]] = AwsError.unwrapOptionField("roots", rootsValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListRootsResponse
  ) extends io.github.vigoo.zioaws.organizations.model.ListRootsResponse.ReadOnly {
    override def rootsValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.Root.ReadOnly]
    ] = scala
      .Option(impl.roots())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.Root.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListRootsResponse
  ): io.github.vigoo.zioaws.organizations.model.ListRootsResponse.ReadOnly =
    new Wrapper(impl)
}
